/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.ops.operation.iterableinterval.unary;

import net.imglib2.Cursor;
import net.imglib2.Localizable;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.RealRandomAccess;
import net.imglib2.interpolation.randomaccess.LanczosInterpolatorFactory;
import net.imglib2.interpolation.randomaccess.NLinearInterpolatorFactory;
import net.imglib2.interpolation.randomaccess.NearestNeighborInterpolatorFactory;
import net.imglib2.ops.operation.UnaryOperation;
import net.imglib2.outofbounds.OutOfBounds;
import net.imglib2.outofbounds.OutOfBoundsFactory;
import net.imglib2.outofbounds.OutOfBoundsMirrorFactory;
import net.imglib2.type.Type;
import net.imglib2.type.numeric.RealType;
import net.imglib2.view.Views;

@Deprecated
public class Resample<T extends RealType<T>>
implements UnaryOperation<RandomAccessibleInterval<T>, RandomAccessibleInterval<T>> {
    private final Mode m_mode;

    public Resample(Mode mode) {
        this.m_mode = mode;
    }

    @Override
    public RandomAccessibleInterval<T> compute(RandomAccessibleInterval<T> op, RandomAccessibleInterval<T> res) {
        NLinearInterpolatorFactory ifac;
        switch (this.m_mode) {
            case LINEAR: {
                ifac = new NLinearInterpolatorFactory();
                break;
            }
            case NEAREST_NEIGHBOR: {
                ifac = new NearestNeighborInterpolatorFactory();
                break;
            }
            case LANCZOS: {
                ifac = new LanczosInterpolatorFactory();
                break;
            }
            case PERIODICAL: {
                OutOfBounds srcRA = Views.extendPeriodic(op).randomAccess();
                Cursor resCur = Views.iterable(res).localizingCursor();
                while (resCur.hasNext()) {
                    resCur.fwd();
                    srcRA.setPosition((Localizable)resCur);
                    ((RealType)resCur.get()).set((Type)srcRA.get());
                }
                return res;
            }
            default: {
                throw new IllegalArgumentException("Unknown mode in Resample.java");
            }
        }
        RealRandomAccess inter = ifac.create((Object)Views.extend(op, (OutOfBoundsFactory)new OutOfBoundsMirrorFactory(OutOfBoundsMirrorFactory.Boundary.SINGLE)));
        Cursor c2 = Views.iterable(res).localizingCursor();
        float[] s = new float[res.numDimensions()];
        for (int i = 0; i < s.length; ++i) {
            s[i] = (float)op.dimension(i) / (float)res.dimension(i);
        }
        long[] d = new long[res.numDimensions()];
        while (c2.hasNext()) {
            c2.fwd();
            c2.localize(d);
            for (int i = 0; i < d.length; ++i) {
                inter.setPosition(s[i] * (float)d[i], i);
            }
            ((RealType)c2.get()).set((Type)inter.get());
        }
        return res;
    }

    @Override
    public UnaryOperation<RandomAccessibleInterval<T>, RandomAccessibleInterval<T>> copy() {
        return new Resample<T>(this.m_mode);
    }

    public static enum Mode {
        LINEAR,
        NEAREST_NEIGHBOR,
        PERIODICAL,
        LANCZOS;

    }
}

