/*
 * Decompiled with CFR 0.152.
 */
package org.janelia.it.jacs.shared.ffmpeg;

import java.util.ArrayList;
import java.util.List;
import org.bytedeco.javacpp.BytePointer;
import org.janelia.it.jacs.shared.ffmpeg.FFMPGByteAcceptor;

public class ByteGatherAcceptor
implements FFMPGByteAcceptor {
    private List<byte[]> pages = new ArrayList<byte[]>();
    private long totalSize = 0L;
    private int width;
    private int height;
    private int pixelBytes;

    public ByteGatherAcceptor() {
        this.setPixelBytes(3);
    }

    @Override
    public void accept(BytePointer data, int linesize, int width, int height) {
        this.setWidth(width);
        this.setHeight(height);
        byte[] page = new byte[linesize * height];
        this.pagewisePageCapture(width, height, linesize, data, page);
        this.totalSize += (long)page.length;
        this.pages.add(page);
    }

    @Override
    public void accept(byte[] page, int linesize, int width, int height) {
        this.setWidth(width);
        this.setHeight(height);
        this.totalSize += (long)page.length;
        this.pages.add(page);
    }

    @Override
    public void setFrameNum(int frameNum) {
    }

    @Override
    public void setPixelBytes(int pixelBytes) {
        this.pixelBytes = pixelBytes;
    }

    public boolean isPopulated() {
        return this.pages.size() > 0;
    }

    public List<byte[]> getBytes() {
        if (!this.isPopulated()) {
            throw new IllegalStateException("Must first accept some bytes.");
        }
        return this.pages;
    }

    public int getNumPages() {
        return this.getBytes().size();
    }

    public long getTotalSize() {
        return this.totalSize;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        if (this.width > 0 && this.width != width) {
            String message = String.format("Width %d differs from accepted width of %d", width, this.width);
            throw new IllegalStateException(message);
        }
        this.width = width;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        if (this.height > 0 && this.height != height) {
            String message = String.format("Height %d differs from accepted height of %d", height, this.height);
            throw new IllegalStateException(message);
        }
        this.height = height;
    }

    public int getPixelBytes() {
        return this.pixelBytes;
    }

    private void linewisePageCapture(int width, int height, int linesize, BytePointer data, byte[] page) {
        byte[] bytes = new byte[width * this.pixelBytes];
        for (int y = 0; y < height; ++y) {
            int lineInPagePos = y * linesize;
            BytePointer ptr = data.position((long)lineInPagePos);
            ptr.get(bytes);
            System.arraycopy(bytes, 0, page, y * linesize, bytes.length);
        }
    }

    private void pagewisePageCapture(int width, int height, int linesize, BytePointer data, byte[] page) {
        BytePointer ptr = data.position(0L);
        ptr.get(page);
    }
}

