/*
 * Decompiled with CFR 0.152.
 */
package bdv.cache;

import java.util.concurrent.CopyOnWriteArrayList;

public interface CacheControl {
    public void prepareNextFrame();

    public static class CacheControls
    implements CacheControl {
        private final CopyOnWriteArrayList<CacheControl> cacheControls = new CopyOnWriteArrayList();

        public synchronized void addCacheControl(CacheControl cacheControl, int index) {
            this.cacheControls.remove(cacheControl);
            int s = this.cacheControls.size();
            this.cacheControls.add(index < 0 ? 0 : (index > s ? s : index), cacheControl);
        }

        public synchronized void addCacheControl(CacheControl cacheControl) {
            if (!this.cacheControls.contains(cacheControl)) {
                this.cacheControls.add(cacheControl);
            }
        }

        public synchronized void removeCacheControl(CacheControl cacheControl) {
            this.cacheControls.remove(cacheControl);
        }

        public synchronized void clear() {
            this.cacheControls.clear();
        }

        @Override
        public void prepareNextFrame() {
            for (CacheControl c : this.cacheControls) {
                c.prepareNextFrame();
            }
        }
    }

    public static class Dummy
    implements CacheControl {
        @Override
        public void prepareNextFrame() {
        }
    }
}

