/*
 * Decompiled with CFR 0.152.
 */
package bdv.tools.brightness;

import bdv.tools.brightness.ConverterSetup;
import bdv.util.BoundedIntervalDouble;
import java.util.LinkedHashSet;
import java.util.Set;

public class MinMaxGroup
extends BoundedIntervalDouble {
    private final double fullRangeMin;
    private final double fullRangeMax;
    final Set<ConverterSetup> setups;
    private UpdateListener updateListener;

    public MinMaxGroup(double fullRangeMin, double fullRangeMax, double rangeMin, double rangeMax, double currentMin, double currentMax, double minIntervalSize) {
        super(rangeMin, rangeMax, currentMin, currentMax, minIntervalSize);
        this.fullRangeMin = fullRangeMin;
        this.fullRangeMax = fullRangeMax;
        this.setups = new LinkedHashSet<ConverterSetup>();
        this.updateListener = null;
    }

    @Override
    protected void updateInterval(double min, double max) {
        for (ConverterSetup setup : this.setups) {
            setup.setDisplayRange(min, max);
        }
    }

    public double getFullRangeMin() {
        return this.fullRangeMin;
    }

    public double getFullRangeMax() {
        return this.fullRangeMax;
    }

    public void addSetup(ConverterSetup setup) {
        this.setups.add(setup);
        if (this.updateListener != null) {
            this.updateListener.update();
        }
    }

    public boolean removeSetup(ConverterSetup setup) {
        this.setups.remove(setup);
        if (this.updateListener != null) {
            this.updateListener.update();
        }
        return this.setups.isEmpty();
    }

    public void setUpdateListener(UpdateListener l) {
        this.updateListener = l;
    }

    public static interface UpdateListener {
        public void update();
    }
}

