/*
 * Decompiled with CFR 0.152.
 */
package bdv.ui.settings.style;

import bdv.ui.settings.style.Style;
import bdv.ui.settings.style.StyleManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public abstract class AbstractStyleManager<M extends AbstractStyleManager<M, S>, S extends Style<S>>
implements StyleManager<M, S> {
    protected final List<S> builtinStyles = this.loadBuiltinStyles();
    protected final List<S> userStyles = new ArrayList<S>();
    protected S selectedStyle = (Style)this.builtinStyles.get(0);

    protected AbstractStyleManager() {
    }

    protected abstract List<S> loadBuiltinStyles();

    @Override
    public void set(M other) {
        this.setSnapshot(((AbstractStyleManager)other).getSnapshot());
    }

    @Override
    public List<S> getBuiltinStyles() {
        return this.builtinStyles;
    }

    @Override
    public List<S> getUserStyles() {
        return Collections.unmodifiableList(this.userStyles);
    }

    @Override
    public S getSelectedStyle() {
        return this.selectedStyle;
    }

    @Override
    public synchronized void setSelectedStyle(S style) {
        this.selectedStyle = style;
    }

    @Override
    public synchronized void remove(S style) {
        if (this.selectedStyle.equals(style)) {
            this.setSelectedStyle((Style)this.builtinStyles.get(0));
        }
        this.userStyles.remove(style);
    }

    @Override
    public synchronized void rename(S style, String newName) {
        if (style.getName().equals(newName)) {
            return;
        }
        if (this.nameExists(newName)) {
            throw new IllegalArgumentException(style.getClass().getSimpleName() + " \"" + newName + "\" already exists.");
        }
        style.setName(newName);
    }

    @Override
    public synchronized S duplicate(S style) {
        String newName;
        String prefix;
        int n;
        String name = style.getName();
        Pattern pattern = Pattern.compile("(.+) \\((\\d+)\\)$");
        Matcher matcher = pattern.matcher(name);
        if (matcher.matches()) {
            String nstr = matcher.group(2);
            n = Integer.parseInt(nstr);
            prefix = matcher.group(1);
        } else {
            n = 1;
            prefix = name;
        }
        while (this.nameExists(newName = prefix + " (" + ++n + ")")) {
        }
        Object newStyle = style.copy(newName);
        this.userStyles.add(newStyle);
        return newStyle;
    }

    protected boolean nameExists(String name) {
        return this.styleForName(name).isPresent();
    }

    protected Optional<S> styleForName(String name) {
        return Stream.concat(this.builtinStyles.stream(), this.userStyles.stream()).filter(style -> style.getName().equals(name)).findFirst();
    }

    synchronized Snapshot getSnapshot() {
        return new Snapshot(this);
    }

    synchronized void setSnapshot(Snapshot snapshot) {
        this.userStyles.clear();
        snapshot.userStyles.forEach(s -> this.userStyles.add(s.copy()));
        this.setSelectedStyle(this.styleForName(snapshot.selectedStyleName).orElseGet(() -> (Style)this.builtinStyles.get(0)));
    }

    class Snapshot {
        private final List<S> userStyles;
        private final String selectedStyleName;

        public Snapshot(AbstractStyleManager<M, S> manager) {
            this.userStyles = manager.getUserStyles().stream().map(s -> s.copy()).collect(Collectors.toList());
            this.selectedStyleName = manager.getSelectedStyle().getName();
        }
    }
}

