/*
 * Decompiled with CFR 0.152.
 */
package bdv.ui.viewermodepanel;

import bdv.ui.UIUtils;
import bdv.ui.viewermodepanel.ToggleButton;
import java.awt.Component;
import javax.swing.Icon;
import javax.swing.JLabel;

class LabeledToggleButton
extends ToggleButton {
    private final String text;
    private final String selectedText;
    private final JLabel label;

    public LabeledToggleButton(Icon icon, Icon selectedIcon, String text, String selectedText, String tooltipText, String selectedTooltipText) {
        super(icon, selectedIcon, tooltipText, selectedTooltipText);
        this.text = text;
        this.selectedText = selectedText;
        this.label = new JLabel(text);
        this.setFont(this.label);
        this.add((Component)this.label, "center");
    }

    @Override
    public void setSelected(boolean selected) {
        super.setSelected(selected);
        this.label.setText(selected ? this.selectedText : this.text);
    }

    private void setFont(JLabel label) {
        label.setFont(UIUtils.getFont("monospaced.bold.mini.font"));
    }

    @Override
    public void updateUI() {
        super.updateUI();
        if (this.label != null) {
            this.setFont(this.label);
        }
    }
}

