/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.application;

import com.sun.javafx.PlatformUtil;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;

enum WindowsHighContrastScheme {
    NONE(null),
    HIGH_CONTRAST_BLACK("high.contrast.black.theme"),
    HIGH_CONTRAST_WHITE("high.contrast.white.theme"),
    HIGH_CONTRAST_1("high.contrast.1.theme"),
    HIGH_CONTRAST_2("high.contrast.2.theme");

    private static List<ResourceBundle> resourceBundles;
    private final String themeKey;

    private WindowsHighContrastScheme(String string2) {
        this.themeKey = string2;
    }

    static WindowsHighContrastScheme fromThemeName(String string) {
        if (string == null || resourceBundles == null) {
            return NONE;
        }
        for (WindowsHighContrastScheme windowsHighContrastScheme : WindowsHighContrastScheme.values()) {
            for (ResourceBundle resourceBundle : resourceBundles) {
                if (windowsHighContrastScheme == NONE || !string.equalsIgnoreCase(resourceBundle.getString(windowsHighContrastScheme.themeKey))) continue;
                return windowsHighContrastScheme;
            }
        }
        return NONE;
    }

    static {
        if (PlatformUtil.isWindows()) {
            resourceBundles = Arrays.stream(Locale.getAvailableLocales()).map(locale -> ResourceBundle.getBundle("com/sun/glass/ui/win/themes", locale)).distinct().toList();
        }
    }
}

