/*
 * Decompiled with CFR 0.152.
 */
package edu.mines.jtk.dsp;

import edu.mines.jtk.util.ArrayMath;
import edu.mines.jtk.util.Check;

public class Sampling {
    public static final double DEFAULT_TOLERANCE = 1.0E-6;
    private int _n;
    private double _d;
    private double _f;
    private double[] _v;
    private double _t;
    private double _td;

    public Sampling(int n) {
        this(n, 1.0, 0.0);
    }

    public Sampling(int n, double d, double f) {
        this(n, d, f, 1.0E-6);
    }

    public Sampling(int n, double d, double f, double t) {
        Check.argument(n > 0, "n>0");
        Check.argument(d > 0.0, "d>0.0");
        this._n = n;
        this._d = d;
        this._f = f;
        this._v = null;
        this._t = t;
        this._td = this._t * this._d;
    }

    public Sampling(double[] v) {
        this(v, 1.0E-6);
    }

    public Sampling(double[] v, double t) {
        Check.argument(v.length > 0, "v.length>0");
        Check.argument(ArrayMath.isIncreasing(v), "v is increasing");
        this._n = v.length;
        this._d = this._n < 2 ? 1.0 : (v[this._n - 1] - v[0]) / (double)(this._n - 1);
        this._f = v[0];
        this._t = t;
        this._td = this._t * this._d;
        boolean uniform = true;
        for (int i = 0; i < this._n && uniform; ++i) {
            double vi = this._f + (double)i * this._d;
            if (this.almostEqual(v[i], vi, this._td)) continue;
            uniform = false;
        }
        this._v = uniform ? null : ArrayMath.copy(v);
    }

    public int getCount() {
        return this._n;
    }

    public double getDelta() {
        return this._d;
    }

    public double getFirst() {
        return this._f;
    }

    public double getLast() {
        return this._v != null ? this._v[this._n - 1] : this._f + (double)(this._n - 1) * this._d;
    }

    public double getValue(int i) {
        Check.index(this._n, i);
        return this.value(i);
    }

    public double[] getValues() {
        double[] v;
        if (this._v != null) {
            v = ArrayMath.copy(this._v);
        } else {
            v = new double[this._n];
            for (int i = 0; i < this._n; ++i) {
                v[i] = this._f + (double)i * this._d;
            }
        }
        return v;
    }

    public boolean isUniform() {
        return this._v == null;
    }

    public boolean isEquivalentTo(Sampling s) {
        Sampling t = this;
        if (t.isUniform() != s.isUniform()) {
            return false;
        }
        if (t.isUniform()) {
            if (t.getCount() != s.getCount()) {
                return false;
            }
            double tiny = this.tinyWith(s);
            double tf = t.getFirst();
            double tl = t.getLast();
            double sf = s.getFirst();
            double sl = s.getLast();
            return this.almostEqual(tf, sf, tiny) && this.almostEqual(tl, sl, tiny);
        }
        double tiny = this.tinyWith(s);
        for (int i = 0; i < this._n; ++i) {
            if (this.almostEqual(this._v[i], s.value(i), tiny)) continue;
            return false;
        }
        return true;
    }

    public boolean isCompatible(Sampling s) {
        Sampling t = this;
        int nt = t.getCount();
        int ns = s.getCount();
        double tf = t.getFirst();
        double sf = s.getFirst();
        double tl = t.getLast();
        double sl = s.getLast();
        int it = 0;
        int is = 0;
        int jt = nt - 1;
        int js = ns - 1;
        if (tl < sf) {
            return true;
        }
        if (sl < tf) {
            return true;
        }
        if (tf < sf) {
            it = t.indexOf(sf);
        } else {
            is = s.indexOf(tf);
        }
        if (it < 0 || is < 0) {
            return false;
        }
        if (tl < sl) {
            js = s.indexOf(tl);
        } else {
            jt = t.indexOf(sl);
        }
        if (jt < 0 || js < 0) {
            return false;
        }
        int mt = 1 + jt - it;
        int ms = 1 + js - is;
        if (mt != ms) {
            return false;
        }
        if (!t.isUniform() || !s.isUniform()) {
            double tiny = this.tinyWith(s);
            jt = it;
            js = is;
            while (jt != mt) {
                if (!this.almostEqual(t.value(jt), s.value(js), tiny)) {
                    return false;
                }
                ++jt;
                ++js;
            }
        }
        return true;
    }

    public int indexOf(double x) {
        int i = -1;
        if (this.isUniform()) {
            int j = (int)Math.round((x - this._f) / this._d);
            if (0 <= j && j < this._n && this.almostEqual(x, this._f + (double)j * this._d, this._td)) {
                i = j;
            }
        } else {
            int j = ArrayMath.binarySearch(this._v, x);
            if (0 <= j) {
                i = j;
            } else if ((j = -(j + 1)) > 0 && this.almostEqual(x, this._v[j - 1], this._td)) {
                i = j - 1;
            } else if (j < this._n && this.almostEqual(x, this._v[j], this._td)) {
                i = j;
            }
        }
        return i;
    }

    public int indexOfNearest(double x) {
        int i;
        if (this.isUniform()) {
            i = (int)Math.round((x - this._f) / this._d);
            if (i < 0) {
                i = 0;
            }
            if (i >= this._n) {
                i = this._n - 1;
            }
        } else {
            i = ArrayMath.binarySearch(this._v, x);
            if (i < 0) {
                if ((i = -(i + 1)) == this._n) {
                    i = this._n - 1;
                } else if (i > 0 && Math.abs(x - this._v[i - 1]) < Math.abs(x - this._v[i])) {
                    --i;
                }
            }
        }
        return i;
    }

    public double valueOfNearest(double x) {
        return this.getValue(this.indexOfNearest(x));
    }

    public boolean isInBounds(int i) {
        return 0 <= i && i < this._n;
    }

    public boolean isInBounds(double x) {
        return this.getFirst() <= x && x <= this.getLast();
    }

    public boolean isInBoundsExtended(double x) {
        Check.state(this.isUniform(), "sampling is uniform");
        double dhalf = 0.5 * this._d;
        return this.getFirst() - dhalf <= x && x <= this.getLast() + dhalf;
    }

    public double getValueExtended(int i) {
        Check.state(this.isUniform(), "sampling is uniform");
        return this._f + (double)i * this._d;
    }

    public int indexOfNearestExtended(double x) {
        Check.state(this.isUniform(), "sampling is uniform");
        return (int)Math.round((x - this._f) / this._d);
    }

    public double valueOfNearestExtended(double x) {
        return this.getValueExtended(this.indexOfNearestExtended(x));
    }

    public int indexOfFloorExtended(double x) {
        Check.state(this.isUniform(), "sampling is uniform");
        double xn = (x - this._f) / this._d;
        int ix = (int)xn;
        return (double)ix <= xn ? ix : ix - 1;
    }

    public double normalizedDifferenceExtended(double x, int i) {
        Check.state(this.isUniform(), "sampling is uniform");
        return (x - (this._f + (double)i * this._d)) / this._d;
    }

    public int[] overlapWith(Sampling s) {
        Sampling t = this;
        int nt = t.getCount();
        int ns = s.getCount();
        double tf = t.getFirst();
        double sf = s.getFirst();
        double tl = t.getLast();
        double sl = s.getLast();
        int it = 0;
        int is = 0;
        int jt = nt - 1;
        int js = ns - 1;
        if (tl < sf) {
            return new int[]{0, nt, 0};
        }
        if (sl < tf) {
            return new int[]{0, 0, ns};
        }
        if (tf < sf) {
            it = t.indexOf(sf);
        } else {
            is = s.indexOf(tf);
        }
        if (it < 0 || is < 0) {
            return null;
        }
        if (tl < sl) {
            js = s.indexOf(tl);
        } else {
            jt = t.indexOf(sl);
        }
        if (jt < 0 || js < 0) {
            return null;
        }
        int mt = 1 + jt - it;
        int ms = 1 + js - is;
        if (mt != ms) {
            return null;
        }
        if (!t.isUniform() || !s.isUniform()) {
            double tiny = this.tinyWith(s);
            jt = it;
            js = is;
            while (jt != mt) {
                if (!this.almostEqual(t.value(jt), s.value(js), tiny)) {
                    return null;
                }
                ++jt;
                ++js;
            }
        }
        return new int[]{mt, it, is};
    }

    public Sampling mergeWith(Sampling s) {
        int js;
        int jt;
        Sampling t = this;
        int[] overlap = t.overlapWith(s);
        if (overlap == null) {
            return null;
        }
        int n = overlap[0];
        int it = overlap[1];
        int is = overlap[2];
        int nt = t.getCount();
        int ns = s.getCount();
        int nm = nt + ns - n;
        if (n > 0 && t.isUniform() && s.isUniform()) {
            double dm = t.getDelta();
            double fm = it == 0 ? s.getFirst() : t.getFirst();
            return new Sampling(nm, dm, fm);
        }
        double[] vm = new double[nm];
        int jm = 0;
        for (jt = 0; jt < it; ++jt) {
            vm[jm++] = t.value(jt);
        }
        for (js = 0; js < is; ++js) {
            vm[jm++] = s.value(js);
        }
        for (jt = it; jt < it + n; ++jt) {
            vm[jm++] = t.value(jt);
        }
        for (jt = it + n; jt < nt; ++jt) {
            vm[jm++] = t.value(jt);
        }
        for (js = is + n; js < ns; ++js) {
            vm[jm++] = s.value(js);
        }
        return new Sampling(vm);
    }

    public Sampling shift(double s) {
        if (this._v == null) {
            return new Sampling(this._n, this._d, this._f + s, this._t);
        }
        double[] v = new double[this._n];
        for (int i = 0; i < this._n; ++i) {
            v[i] = this._v[i] + s;
        }
        return new Sampling(v, this._t);
    }

    public Sampling prepend(int m) {
        int i;
        int n = this._n + m;
        double f = this._f - (double)m * this._d;
        if (this._v == null) {
            return new Sampling(n, this._d, f, this._t);
        }
        double[] v = new double[n];
        for (i = 0; i < m; ++i) {
            v[i] = f + (double)i * this._d;
        }
        for (i = m; i < n; ++i) {
            v[i] = this._v[i - m];
        }
        return new Sampling(v, this._t);
    }

    public Sampling append(int m) {
        int i;
        int n = this._n + m;
        if (this._v == null) {
            return new Sampling(n, this._d, this._f, this._t);
        }
        double[] v = new double[n];
        for (i = 0; i < this._n; ++i) {
            v[i] = this._v[i];
        }
        for (i = this._n; i < n; ++i) {
            v[i] = this._f + (double)i * this._d;
        }
        return new Sampling(v, this._t);
    }

    public Sampling decimate(int m) {
        Check.argument(m > 0, "m>0");
        int n = 1 + (this._n - 1) / m;
        if (this._v == null) {
            return new Sampling(n, (double)m * this._d, this._f, this._t);
        }
        double[] v = new double[n];
        int i = 0;
        int j = 0;
        while (i < n) {
            v[i] = this._v[j];
            ++i;
            j += m;
        }
        return new Sampling(v, this._t);
    }

    public Sampling interpolate(int m) {
        Check.argument(m > 0, "m>0");
        int n = this._n + (this._n - 1) * (m - 1);
        if (this._v == null) {
            return new Sampling(n, this._d / (double)m, this._f, this._t);
        }
        double[] v = new double[n];
        v[0] = this._v[0];
        int i = 1;
        int j = m;
        while (i < this._n) {
            v[j] = this._v[i];
            double dk = (v[j] - v[j - m]) / (double)m;
            double vk = v[j - m];
            int k = j - m + 1;
            while (k < j) {
                v[k] = vk;
                ++k;
                vk += dk;
            }
            ++i;
            j += m;
        }
        return new Sampling(v, this._t);
    }

    private double value(int i) {
        return this._v != null ? this._v[i] : this._f + (double)i * this._d;
    }

    private boolean almostEqual(double v1, double v2, double tiny) {
        double diff = v1 - v2;
        return diff < 0.0 ? -diff < tiny : diff < tiny;
    }

    private double tinyWith(Sampling s) {
        return this._td < s._td ? this._td : s._td;
    }
}

