/*
 * Decompiled with CFR 0.152.
 */
package edu.mines.jtk.util;

import edu.mines.jtk.util.MathPlus;

public class AxisTics {
    private double _xmin;
    private double _xmax;
    private int _mtic;
    private int _ntic;
    private double _dtic;
    private double _ftic;
    private int _nticMinor;
    private double _dticMinor;
    private double _fticMinor;
    private static final int[] _mult = new int[]{2, 5, 10};

    public AxisTics(double x1, double x2, double dtic) {
        double xmin = MathPlus.min(x1, x2);
        double xmax = MathPlus.max(x1, x2);
        xmin -= (xmax - xmin) * 1.1920928955078125E-7;
        xmax += (xmax - xmin) * 1.1920928955078125E-7;
        double d = MathPlus.abs(dtic);
        double f = MathPlus.ceil(xmin / d) * d;
        int n = 1 + (int)((xmax - f) / d);
        this._xmin = xmin;
        this._xmax = xmax;
        this._ntic = n;
        this._dtic = d;
        this._ftic = f;
        this.computeMultiple();
        this.computeMinorTics();
    }

    public AxisTics(double x1, double x2, int ntic) {
        double xmin = this._xmin = MathPlus.min(x1, x2);
        double xmax = this._xmax = MathPlus.max(x1, x2);
        xmin -= (xmax - xmin) * 1.1920928955078125E-7;
        xmax += (xmax - xmin) * 1.1920928955078125E-7;
        int nmax = ntic >= 2 ? ntic : 2;
        double dmax = (xmax - xmin) / (double)(nmax - 1);
        int nmult = _mult.length;
        int nbest = 0;
        int mbest = 0;
        double dbest = 0.0;
        double fbest = 0.0;
        for (int imult = 0; imult < nmult; ++imult) {
            int m = _mult[imult];
            int l = (int)MathPlus.floor(MathPlus.log10(dmax / (double)m));
            double d = (double)m * MathPlus.pow(10.0, (double)l);
            double f = MathPlus.ceil(xmin / d) * d;
            int n = 1 + (int)((xmax - f) / d);
            if (n > nmax) {
                f = MathPlus.ceil(xmin / (d *= 10.0)) * d;
                n = 1 + (int)((xmax - f) / d);
            }
            if (nbest >= n || n > ntic) continue;
            nbest = n;
            mbest = m;
            dbest = d;
            fbest = f;
        }
        nbest = 1 + (int)((xmax - fbest) / dbest);
        if (nbest < 2) {
            this._ntic = 2;
            this._dtic = this._xmax - this._xmin;
            this._ftic = this._xmin;
            this.computeMultiple();
        } else {
            this._ntic = nbest;
            this._dtic = dbest;
            this._ftic = fbest;
            this._mtic = mbest;
        }
        this.computeMinorTics();
    }

    public int getCountMajor() {
        return this._ntic;
    }

    public double getDeltaMajor() {
        return this._dtic;
    }

    public double getFirstMajor() {
        return this._ftic;
    }

    public int getCountMinor() {
        return this._nticMinor;
    }

    public double getDeltaMinor() {
        return this._dticMinor;
    }

    public double getFirstMinor() {
        return this._fticMinor;
    }

    public int getMultiple() {
        return this._mtic;
    }

    private void computeMultiple() {
        this._mtic = 1;
        double l10 = MathPlus.log10(this._dtic / 10.0);
        double l5 = MathPlus.log10(this._dtic / 5.0);
        double l2 = MathPlus.log10(this._dtic / 2.0);
        if (AxisTics.almostEqual(MathPlus.rint(l10), l10)) {
            this._mtic = 10;
        } else if (AxisTics.almostEqual(MathPlus.rint(l5), l5)) {
            this._mtic = 5;
        } else if (AxisTics.almostEqual(MathPlus.rint(l2), l2)) {
            this._mtic = 2;
        }
    }

    private void computeMinorTics() {
        int nm;
        double dm = this._dtic / (double)this._mtic;
        double fm = this._ftic;
        while (this._xmin <= fm - dm) {
            fm -= dm;
        }
        this._nticMinor = nm = 1 + (int)((this._xmax - fm) / dm);
        this._dticMinor = dm;
        this._fticMinor = fm;
    }

    private static boolean almostEqual(double x1, double x2) {
        return MathPlus.abs(x1 - x2) <= MathPlus.max(MathPlus.abs(x1), MathPlus.abs(x2)) * 100.0 * 2.220446049250313E-16;
    }
}

