/*
 * Decompiled with CFR 0.152.
 */
package edu.mines.jtk.util;

import edu.mines.jtk.util.Check;
import edu.mines.jtk.util.UnitsFormatException;
import edu.mines.jtk.util.UnitsParser;
import edu.mines.jtk.util.UnitsSpecs;
import java.util.Hashtable;
import java.util.StringTokenizer;

public final class Units
implements Cloneable {
    private static final int NPOWERS = 16;
    private static Hashtable<String, UnitsTableEntry> _table = null;
    private static String[] _bases = null;
    private static int _nbase = 0;
    private static final String[] _prefix_string = new String[]{"E", "G", "M", "P", "T", "Y", "Z", "a", "atto", "c", "centi", "d", "da", "deca", "deci", "deka", "exa", "f", "femto", "giga", "h", "hecto", "k", "kilo", "m", "mega", "micro", "milli", "n", "nano", "p", "peta", "pico", "tera", "u", "y", "yocto", "yotta", "z", "zepto", "zetta"};
    private static final double[] _prefix_factor = new double[]{1.0E18, 1.0E9, 1000000.0, 1.0E15, 1.0E12, 1.0E24, 1.0E21, 1.0E-18, 1.0E-18, 0.01, 0.01, 0.1, 10.0, 10.0, 0.1, 10.0, 1.0E18, 1.0E-15, 1.0E-15, 1.0E9, 100.0, 100.0, 1000.0, 1000.0, 0.001, 1000000.0, 1.0E-6, 0.001, 1.0E-9, 1.0E-9, 1.0E-12, 1.0E15, 1.0E-12, 1.0E12, 1.0E-6, 1.0E-24, 1.0E-24, 1.0E24, 1.0E-21, 1.0E-21, 1.0E21};
    private double _scale = 1.0;
    private double _shift = 0.0;
    private byte[] _power = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};

    public Units() {
    }

    public Units(String definition) throws UnitsFormatException {
        Units units = Units.unitsFromDefinition(definition);
        this._scale = units._scale;
        this._shift = units._shift;
        for (int i = 0; i < this._power.length; ++i) {
            this._power[i] = units._power[i];
        }
    }

    public Object clone() {
        try {
            Units units = (Units)super.clone();
            units._power = (byte[])this._power.clone();
            return units;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    public boolean equals(Object object) {
        if (object instanceof Units) {
            return this.equals((Units)object);
        }
        return false;
    }

    public boolean equals(Units units) {
        if (this._scale != units._scale) {
            return false;
        }
        if (this._shift != units._shift) {
            return false;
        }
        for (int i = 0; i < this._power.length; ++i) {
            if (this._power[i] == units._power[i]) continue;
            return false;
        }
        return true;
    }

    public float toSI(float value) {
        return (float)(((double)value - this._shift) * this._scale);
    }

    public double toSI(double value) {
        return (value - this._shift) * this._scale;
    }

    public float fromSI(float value) {
        return (float)(this._shift + (double)value / this._scale);
    }

    public double fromSI(double value) {
        return this._shift + value / this._scale;
    }

    public float floatShiftFrom(Units units) {
        return (float)this.doubleShiftFrom(units);
    }

    public double doubleShiftFrom(Units units) {
        Check.argument(units.haveDimensionsOf(this), "same dimensions");
        return this.fromSI(units.toSI(0.0));
    }

    public float floatScaleFrom(Units units) {
        return (float)this.doubleScaleFrom(units);
    }

    public double doubleScaleFrom(Units units) {
        Check.argument(units.haveDimensionsOf(this), "same dimensions");
        return this.fromSI(units.toSI(1.0)) - this.doubleShiftFrom(units);
    }

    public boolean haveDimensions() {
        for (byte power : this._power) {
            if (power == 0) continue;
            return true;
        }
        return false;
    }

    public boolean haveDimensionsOf(Units units) {
        for (int i = 0; i < this._power.length; ++i) {
            if (this._power[i] == units._power[i]) continue;
            return false;
        }
        return true;
    }

    public String standardDefinition() {
        String sd = "";
        boolean appending = false;
        if (this._scale != 1.0) {
            sd = sd + this._scale;
            appending = true;
        }
        for (int i = 0; i < _nbase; ++i) {
            if (this._power[i] == 0) continue;
            if (appending) {
                sd = sd + " ";
            }
            sd = sd + _bases[i];
            if (this._power[i] != 1) {
                sd = sd + "^" + this._power[i];
            }
            appending = true;
        }
        if (this._shift != 0.0) {
            double abs_shift;
            double d = abs_shift = this._shift > 0.0 ? this._shift : -this._shift;
            if (appending) {
                sd = sd + " ";
            }
            sd = sd + (this._shift > 0.0 ? "+ " : "- ");
            sd = sd + abs_shift;
        }
        return sd;
    }

    public static Units add(Units units, double s) {
        return ((Units)units.clone()).shift(s);
    }

    public static Units sub(Units units, double s) {
        return ((Units)units.clone()).shift(-s);
    }

    public static Units mul(Units units, double s) {
        return ((Units)units.clone()).scale(s);
    }

    public static Units div(Units units, double s) {
        return ((Units)units.clone()).scale(1.0 / s);
    }

    public static Units mul(Units units1, Units units2) {
        return ((Units)units1.clone()).mul(units2);
    }

    public static Units div(Units units1, Units units2) {
        return ((Units)units1.clone()).div(units2);
    }

    public static Units inv(Units units) {
        return ((Units)units.clone()).inv();
    }

    public static Units pow(Units units, int p) {
        return ((Units)units.clone()).pow(p);
    }

    public static synchronized boolean define(String name, boolean plural, String definition) throws UnitsFormatException {
        return Units.addDefinition(name, plural, definition);
    }

    public static synchronized boolean isValidDefinition(String definition) {
        try {
            Units.unitsFromDefinition(definition);
        }
        catch (UnitsFormatException e) {
            return false;
        }
        return true;
    }

    public static synchronized boolean isDefined(String name) {
        return _table.containsKey(name);
    }

    Units scale(double s) {
        this._scale *= s;
        this._shift /= s;
        return this;
    }

    Units shift(double s) {
        this._shift += s;
        return this;
    }

    Units mul(Units u) {
        this._shift = this._shift != 0.0 ? this._shift / u._scale : u._shift / this._scale;
        this._scale *= u._scale;
        for (int i = 0; i < this._power.length; ++i) {
            int n = i;
            this._power[n] = (byte)(this._power[n] + u._power[i]);
        }
        return this;
    }

    Units div(Units u) {
        this._shift *= u._scale;
        this._scale /= u._scale;
        for (int i = 0; i < this._power.length; ++i) {
            int n = i;
            this._power[n] = (byte)(this._power[n] - u._power[i]);
        }
        return this;
    }

    Units inv() {
        this._scale = 1.0 / this._scale;
        this._shift = 0.0;
        for (int i = 0; i < this._power.length; ++i) {
            this._power[i] = -this._power[i];
        }
        return this;
    }

    Units pow(int p) {
        this._scale = Math.pow(this._scale, p);
        this._shift = 0.0;
        int i = 0;
        while (i < this._power.length) {
            int n = i++;
            this._power[n] = (byte)(this._power[n] * (byte)p);
        }
        return this;
    }

    static synchronized Units unitsFromName(String name) {
        boolean suffix;
        boolean prefix;
        if (name == null || name.equals("")) {
            return new Units();
        }
        UnitsTableEntry entry = _table.get(name);
        if (entry != null) {
            return (Units)entry._units.clone();
        }
        double factor = 1.0;
        int index = Units.findPrefix(name);
        boolean bl = prefix = index >= 0;
        if (prefix) {
            factor = _prefix_factor[index];
            String temp = name.substring(_prefix_string[index].length());
            entry = _table.get(temp);
            if (entry != null) {
                Units units = (Units)entry._units.clone();
                units.scale(factor);
                return units;
            }
        }
        boolean bl2 = suffix = name.length() > 0 && name.charAt(name.length() - 1) == 's';
        if (suffix && (entry = _table.get(name = name.substring(0, name.length() - 1))) != null && entry._plural) {
            Units units = (Units)entry._units.clone();
            return units;
        }
        if (prefix && suffix && (entry = _table.get(name = name.substring(_prefix_string[index].length()))) != null && entry._plural) {
            Units units = (Units)entry._units.clone();
            units.scale(factor);
            return units;
        }
        return null;
    }

    private static synchronized Units unitsFromDefinition(String definition) throws UnitsFormatException {
        Units units = Units.unitsFromName(definition);
        if (units != null) {
            return units;
        }
        try {
            return UnitsParser.parse(definition);
        }
        catch (Exception e) {
            throw new UnitsFormatException(e.getMessage());
        }
    }

    private static int findPrefix(String name) {
        if (name.length() < 1) {
            return -1;
        }
        char name0 = name.charAt(0);
        int length = 0;
        int index = -1;
        for (int i = 0; i < _prefix_string.length; ++i) {
            String prefix = _prefix_string[i];
            char prefix0 = prefix.charAt(0);
            if (name0 > prefix0) continue;
            if (name0 < prefix0) break;
            if (!name.startsWith(prefix) || length >= prefix.length()) continue;
            length = prefix.length();
            index = i;
        }
        return index;
    }

    private static synchronized boolean addDefinition(String name, boolean plural, String definition) throws UnitsFormatException {
        if (_table.containsKey(name)) {
            return false;
        }
        if (definition == null || definition.equals("")) {
            Units units = new Units();
            if (_nbase >= units._power.length - 1) {
                return false;
            }
            int n = _nbase;
            units._power[n] = (byte)(units._power[n] + 1);
            Units._bases[Units._nbase++] = name;
            _table.put(name, new UnitsTableEntry(name, plural, units));
            return true;
        }
        Units units = Units.unitsFromDefinition(definition);
        _table.put(name, new UnitsTableEntry(name, plural, units));
        return true;
    }

    private static synchronized void loadTable() {
        String[] specs;
        for (String spec : specs = UnitsSpecs.specs) {
            String definition;
            StringTokenizer st;
            if (spec.startsWith("#") || (st = new StringTokenizer(spec)).countTokens() < 2) continue;
            String name = st.nextToken();
            String plural_str = st.nextToken();
            if (!plural_str.equals("S") && !plural_str.equals("P")) continue;
            boolean plural = plural_str.equals("P");
            String string = definition = st.hasMoreTokens() ? st.nextToken("") : null;
            if (definition != null) {
                int index = definition.indexOf("#");
                if (index >= 0) {
                    definition = definition.substring(0, index);
                }
                definition = definition.trim();
            }
            if (definition != null && definition.equals("")) {
                definition = null;
            }
            try {
                boolean defined = Units.addDefinition(name, plural, definition);
                if (defined) continue;
                System.err.println("Units.loadTable: failed to define " + name + " = " + definition);
            }
            catch (UnitsFormatException e) {
                System.err.println("Units.loadTable: failed to define " + name + " = " + definition + " because " + e.getMessage());
            }
        }
    }

    static {
        _table = new Hashtable();
        _bases = new String[16];
        Units.loadTable();
    }

    private static class UnitsTableEntry {
        String _name = null;
        boolean _plural = false;
        Units _units = null;

        UnitsTableEntry(String name, boolean plural, Units units) {
            this._name = name;
            this._plural = plural;
            this._units = units;
        }
    }
}

