/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.scalar;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import org.ojalgo.constant.PrimitiveMath;
import org.ojalgo.function.PrimitiveFunction;
import org.ojalgo.scalar.BigScalar;
import org.ojalgo.scalar.Scalar;
import org.ojalgo.type.TypeUtils;
import org.ojalgo.type.context.NumberContext;

final class OldRationalNumber
extends Number
implements Scalar<OldRationalNumber>,
NumberContext.Enforceable<OldRationalNumber> {
    public static final Scalar.Factory<OldRationalNumber> FACTORY = new Scalar.Factory<OldRationalNumber>(){

        @Override
        public OldRationalNumber cast(double value) {
            return OldRationalNumber.valueOf(value);
        }

        @Override
        public OldRationalNumber cast(Number number) {
            return OldRationalNumber.valueOf(number);
        }

        public OldRationalNumber convert(double value) {
            return OldRationalNumber.valueOf(value);
        }

        public OldRationalNumber convert(Number number) {
            return OldRationalNumber.valueOf(number);
        }

        public OldRationalNumber one() {
            return ONE;
        }

        public OldRationalNumber zero() {
            return ZERO;
        }
    };
    public static final OldRationalNumber NaN = new OldRationalNumber(BigInteger.ZERO, BigInteger.ZERO);
    public static final OldRationalNumber NEG = new OldRationalNumber(BigInteger.ONE.negate(), BigInteger.ONE);
    public static final OldRationalNumber NEGATIVE_INFINITY = new OldRationalNumber(BigInteger.ONE.negate(), BigInteger.ZERO);
    public static final OldRationalNumber ONE = new OldRationalNumber(BigInteger.ONE, BigInteger.ONE);
    public static final OldRationalNumber POSITIVE_INFINITY = new OldRationalNumber(BigInteger.ONE, BigInteger.ZERO);
    public static final OldRationalNumber TWO = new OldRationalNumber(BigInteger.ONE.add(BigInteger.ONE), BigInteger.ONE);
    public static final OldRationalNumber ZERO = new OldRationalNumber(BigInteger.ZERO, BigInteger.ONE);
    private static final String DIVIDE = " / ";
    private static final String LEFT = "(";
    private static final String RIGHT = ")";
    private transient BigDecimal myDecimal = null;
    private final BigInteger myDenominator;
    private final BigInteger myNumerator;

    public static BigInteger gcd(BigInteger value1, BigInteger value2) {
        return value1.gcd(value2);
    }

    public static int gcd(int value1, int value2) {
        int retVal = 1;
        value1 = Math.abs(value1);
        value2 = Math.abs(value2);
        int tmpMax = Math.max(value1, value2);
        int tmpMin = Math.min(value1, value2);
        while (tmpMin != 0) {
            retVal = tmpMin;
            tmpMin = tmpMax % tmpMin;
            tmpMax = retVal;
        }
        return retVal;
    }

    public static long gcd(long value1, long value2) {
        long retVal = 1L;
        value1 = Math.abs(value1);
        value2 = Math.abs(value2);
        long tmpMax = Math.max(value1, value2);
        long tmpMin = Math.min(value1, value2);
        while (tmpMin != 0L) {
            retVal = tmpMin;
            tmpMin = tmpMax % tmpMin;
            tmpMax = retVal;
        }
        return retVal;
    }

    public static boolean isAbsolute(OldRationalNumber value) {
        return value.isAbsolute();
    }

    public static boolean isInfinite(OldRationalNumber value) {
        return value.getNumerator().signum() != 0 && value.getDenominator().signum() == 0;
    }

    public static boolean isNaN(OldRationalNumber value) {
        return value.getNumerator().signum() == 0 && value.getDenominator().signum() == 0;
    }

    public static boolean isSmall(double comparedTo, OldRationalNumber value) {
        return value.isSmall(comparedTo);
    }

    public static OldRationalNumber of(long numerator, long denominator) {
        BigInteger tmpDenominator;
        BigInteger tmpNumerator;
        long tmpGCD = OldRationalNumber.gcd(numerator, denominator);
        if (denominator < 0L) {
            tmpGCD = -tmpGCD;
        }
        if (tmpGCD != 1L) {
            tmpNumerator = BigInteger.valueOf(numerator / tmpGCD);
            tmpDenominator = BigInteger.valueOf(denominator / tmpGCD);
        } else {
            tmpNumerator = BigInteger.valueOf(numerator);
            tmpDenominator = BigInteger.valueOf(denominator);
        }
        return new OldRationalNumber(tmpNumerator, tmpDenominator);
    }

    public static OldRationalNumber valueOf(double value) {
        return OldRationalNumber.valueOf(BigDecimal.valueOf(value));
    }

    public static OldRationalNumber valueOf(Number number) {
        if (number != null) {
            BigInteger tmpDenominator;
            BigInteger tmpNumerator;
            if (number instanceof OldRationalNumber) {
                return (OldRationalNumber)number;
            }
            BigDecimal tmpBigDecimal = TypeUtils.toBigDecimal(number);
            int tmpScale = tmpBigDecimal.scale();
            if (tmpScale < 0) {
                tmpNumerator = tmpBigDecimal.unscaledValue().multiply(BigInteger.TEN.pow(-tmpScale));
                tmpDenominator = BigInteger.ONE;
            } else {
                BigInteger tmpDenom;
                BigInteger tmpNumer = tmpBigDecimal.unscaledValue();
                BigInteger tmpGCD = tmpNumer.gcd(tmpDenom = BigInteger.TEN.pow(tmpScale));
                if (tmpGCD.compareTo(BigInteger.ONE) == 1) {
                    tmpNumerator = tmpNumer.divide(tmpGCD);
                    tmpDenominator = tmpDenom.divide(tmpGCD);
                } else {
                    tmpNumerator = tmpNumer;
                    tmpDenominator = tmpDenom;
                }
            }
            return new OldRationalNumber(tmpNumerator, tmpDenominator);
        }
        return ZERO;
    }

    private static String toString(OldRationalNumber aNmbr) {
        StringBuilder retVal = new StringBuilder(LEFT);
        retVal.append(aNmbr.getNumerator());
        retVal.append(DIVIDE);
        retVal.append(aNmbr.getDenominator());
        return retVal.append(RIGHT).toString();
    }

    public OldRationalNumber() {
        this(BigInteger.ZERO, BigInteger.ONE);
    }

    private OldRationalNumber(BigInteger numerator, BigInteger denominator) {
        while (numerator.abs().max(denominator.abs()).bitCount() > 64) {
            numerator = numerator.divide(BigInteger.TEN);
            denominator = denominator.divide(BigInteger.TEN);
        }
        if (denominator.signum() >= 0) {
            this.myNumerator = numerator;
            this.myDenominator = denominator;
        } else {
            this.myNumerator = numerator.negate();
            this.myDenominator = denominator.negate();
        }
    }

    @Override
    public OldRationalNumber add(double arg) {
        return this.add(OldRationalNumber.valueOf(arg));
    }

    @Override
    public OldRationalNumber add(OldRationalNumber arg) {
        BigInteger tmpDenom;
        if (this.myDenominator.equals(arg.getDenominator())) {
            return new OldRationalNumber(this.myNumerator.add(arg.getNumerator()), this.myDenominator);
        }
        BigInteger tmpNumer = this.myNumerator.multiply(arg.getDenominator()).add(arg.getNumerator().multiply(this.myDenominator));
        BigInteger tmpGCD = tmpNumer.gcd(tmpDenom = this.myDenominator.multiply(arg.getDenominator()));
        if (tmpGCD.compareTo(BigInteger.ONE) == 1) {
            return new OldRationalNumber(tmpNumer.divide(tmpGCD), tmpDenom.divide(tmpGCD));
        }
        return new OldRationalNumber(tmpNumer, tmpDenom);
    }

    @Override
    public int compareTo(OldRationalNumber reference) {
        return this.toBigDecimal().compareTo(reference.toBigDecimal());
    }

    @Override
    public OldRationalNumber conjugate() {
        return this;
    }

    @Override
    public OldRationalNumber divide(double arg) {
        return this.divide(OldRationalNumber.valueOf(arg));
    }

    @Override
    public OldRationalNumber divide(OldRationalNumber arg) {
        BigInteger tmpDenom;
        if (this.myNumerator.equals(arg.getNumerator())) {
            return new OldRationalNumber(arg.getDenominator(), this.myDenominator);
        }
        if (this.myDenominator.equals(arg.getDenominator())) {
            return new OldRationalNumber(this.myNumerator, arg.getNumerator());
        }
        BigInteger tmpNumer = this.myNumerator.multiply(arg.getDenominator());
        BigInteger tmpGCD = tmpNumer.gcd(tmpDenom = this.myDenominator.multiply(arg.getNumerator()));
        if (tmpGCD.compareTo(BigInteger.ONE) == 1) {
            return new OldRationalNumber(tmpNumer.divide(tmpGCD), tmpDenom.divide(tmpGCD));
        }
        return new OldRationalNumber(tmpNumer, tmpDenom);
    }

    @Override
    public double doubleValue() {
        return this.toBigDecimal().doubleValue();
    }

    @Override
    public OldRationalNumber enforce(NumberContext context) {
        return OldRationalNumber.valueOf(this.toBigDecimal(context.getMathContext()));
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OldRationalNumber)) {
            return false;
        }
        OldRationalNumber other = (OldRationalNumber)obj;
        if (this.myDenominator == null ? other.myDenominator != null : !this.myDenominator.equals(other.myDenominator)) {
            return false;
        }
        return !(this.myNumerator == null ? other.myNumerator != null : !this.myNumerator.equals(other.myNumerator));
    }

    @Override
    public float floatValue() {
        return this.toBigDecimal().floatValue();
    }

    @Override
    public OldRationalNumber get() {
        return this;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.myDenominator == null ? 0 : this.myDenominator.hashCode());
        result = 31 * result + (this.myNumerator == null ? 0 : this.myNumerator.hashCode());
        return result;
    }

    @Override
    public int intValue() {
        return this.toBigDecimal().intValue();
    }

    @Override
    public OldRationalNumber invert() {
        return new OldRationalNumber(this.myDenominator, this.myNumerator);
    }

    @Override
    public boolean isAbsolute() {
        return this.myNumerator.signum() >= 0 && this.myDenominator.signum() > 0;
    }

    @Override
    public boolean isSmall(double comparedTo) {
        return BigScalar.CONTEXT.isSmall(comparedTo, this.doubleValue());
    }

    @Override
    public long longValue() {
        return this.toBigDecimal().longValue();
    }

    @Override
    public OldRationalNumber multiply(double arg) {
        return this.multiply(OldRationalNumber.valueOf(arg));
    }

    @Override
    public OldRationalNumber multiply(OldRationalNumber arg) {
        BigInteger tmpDenom;
        if (this.myNumerator.equals(arg.getDenominator())) {
            return new OldRationalNumber(arg.getNumerator(), this.myDenominator);
        }
        if (this.myDenominator.equals(arg.getNumerator())) {
            return new OldRationalNumber(this.myNumerator, arg.getDenominator());
        }
        BigInteger tmpNumer = this.myNumerator.multiply(arg.getNumerator());
        BigInteger tmpGCD = tmpNumer.gcd(tmpDenom = this.myDenominator.multiply(arg.getDenominator()));
        if (tmpGCD.compareTo(BigInteger.ONE) == 1) {
            return new OldRationalNumber(tmpNumer.divide(tmpGCD), tmpDenom.divide(tmpGCD));
        }
        return new OldRationalNumber(tmpNumer, tmpDenom);
    }

    @Override
    public OldRationalNumber negate() {
        return new OldRationalNumber(this.myNumerator.negate(), this.myDenominator);
    }

    @Override
    public double norm() {
        return PrimitiveFunction.ABS.invoke(this.doubleValue());
    }

    @Override
    public OldRationalNumber signum() {
        if (OldRationalNumber.isSmall(PrimitiveMath.ONE, this)) {
            return ZERO;
        }
        if (this.sign() == -1) {
            return ONE.negate();
        }
        return ONE;
    }

    @Override
    public OldRationalNumber subtract(double arg) {
        return this.subtract(OldRationalNumber.valueOf(arg));
    }

    @Override
    public OldRationalNumber subtract(OldRationalNumber arg) {
        BigInteger tmpDenom;
        if (this.myDenominator.equals(arg.getDenominator())) {
            return new OldRationalNumber(this.myNumerator.subtract(arg.getNumerator()), this.myDenominator);
        }
        BigInteger tmpNumer = this.myNumerator.multiply(arg.getDenominator()).subtract(arg.getNumerator().multiply(this.myDenominator));
        BigInteger tmpGCD = tmpNumer.gcd(tmpDenom = this.myDenominator.multiply(arg.getDenominator()));
        if (tmpGCD.compareTo(BigInteger.ONE) == 1) {
            return new OldRationalNumber(tmpNumer.divide(tmpGCD), tmpDenom.divide(tmpGCD));
        }
        return new OldRationalNumber(tmpNumer, tmpDenom);
    }

    @Override
    public BigDecimal toBigDecimal() {
        if (this.myDecimal == null) {
            this.myDecimal = this.toBigDecimal(BigScalar.CONTEXT.getMathContext());
        }
        return this.myDecimal;
    }

    public String toString() {
        return OldRationalNumber.toString(this);
    }

    @Override
    public String toString(NumberContext context) {
        return OldRationalNumber.toString(this.enforce(context));
    }

    private int sign() {
        return this.myNumerator.signum() * this.myDenominator.signum();
    }

    private BigDecimal toBigDecimal(MathContext context) {
        return new BigDecimal(this.myNumerator).divide(new BigDecimal(this.myDenominator), context);
    }

    BigInteger getDenominator() {
        return this.myDenominator;
    }

    BigInteger getNumerator() {
        return this.myNumerator;
    }
}

