/*
 * Decompiled with CFR 0.152.
 */
package landmarks;

import ij.IJ;
import ij.ImagePlus;
import ij.gui.PointRoi;
import ij.gui.Roi;
import ij.io.FileInfo;
import ij.measure.Calibration;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import landmarks.NamedPointWorld;
import math3d.Point3d;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;
import util.BatchOpener;
import util.opencsv.CSVReader;
import vib.transforms.OrderedTransformations;

public class NamedPointSet {
    ArrayList<NamedPointWorld> pointsWorld = new ArrayList();
    static boolean verbose = true;

    public int size() {
        return this.pointsWorld.size();
    }

    public ListIterator listIterator() {
        return this.pointsWorld.listIterator();
    }

    public NamedPointSet transformPointsWith(OrderedTransformations o) {
        NamedPointSet result = new NamedPointSet();
        ListIterator<NamedPointWorld> i0 = this.pointsWorld.listIterator();
        while (i0.hasNext()) {
            NamedPointWorld p = (NamedPointWorld)i0.next();
            NamedPointWorld transformed = p.transformWith(o);
            result.add(transformed);
        }
        return result;
    }

    public NamedPointWorld getPoint(String name) {
        ListIterator i = this.listIterator();
        while (i.hasNext()) {
            NamedPointWorld p = (NamedPointWorld)i.next();
            if (!p.name.equals(name)) continue;
            return p;
        }
        return null;
    }

    public synchronized NamedPointWorld delete(int i) {
        return this.pointsWorld.remove(i);
    }

    public NamedPointWorld get(int i) {
        return this.pointsWorld.get(i);
    }

    public NamedPointWorld get(String name) {
        ListIterator<NamedPointWorld> i0 = this.pointsWorld.listIterator();
        while (i0.hasNext()) {
            NamedPointWorld p = (NamedPointWorld)i0.next();
            if (!p.getName().equals(name)) continue;
            return p;
        }
        return null;
    }

    public String[] getPointNames() {
        String[] sa = new String[this.pointsWorld.size()];
        int i = 0;
        ListIterator it = this.listIterator();
        while (it.hasNext()) {
            NamedPointWorld p = (NamedPointWorld)it.next();
            sa[i++] = p.name;
        }
        return sa;
    }

    public int getIndexOfPoint(String name) {
        int i = 0;
        for (NamedPointWorld p : this.pointsWorld) {
            if (p.getName().equals(name)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    void showAsROI(int i, ImagePlus imp) {
        NamedPointWorld p = this.pointsWorld.get(i);
        assert (p.set);
        double x = p.x;
        double y = p.y;
        double z = p.z;
        Calibration c = imp.getCalibration();
        if (c != null) {
            x /= c.pixelWidth;
            y /= c.pixelHeight;
            z /= c.pixelDepth;
        }
        int sliceAllChannels = (int)z;
        System.out.println("sliceAllChannels: " + sliceAllChannels);
        int channels = imp.getNChannels();
        int currentChannel = imp.getChannel();
        int slice = sliceAllChannels * channels + currentChannel;
        System.out.println("slice: " + slice);
        imp.setSlice(slice);
        PointRoi roi = new PointRoi((int)x, (int)y);
        imp.setRoi((Roi)roi);
    }

    public boolean savePointsFile(String savePath) {
        try {
            FileOutputStream fos = new FileOutputStream(savePath);
            byte[] asBytes = this.xmlDataAsBytes();
            fos.write(asBytes);
            fos.close();
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    public String xmlDataAsString() {
        StringBuffer result = new StringBuffer();
        result.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        result.append("<!DOCTYPE namedpointset [\n");
        result.append("  <!ELEMENT namedpointset (pointworld*)>\n");
        result.append("  <!ELEMENT pointworld EMPTY>\n");
        result.append("  <!ATTLIST namedpointset version CDATA #REQUIRED>\n");
        result.append("  <!ATTLIST pointworld set (true|false) #REQUIRED>\n");
        result.append("  <!ATTLIST pointworld name CDATA #REQUIRED>\n");
        result.append("  <!ATTLIST pointworld x CDATA #IMPLIED>\n");
        result.append("  <!ATTLIST pointworld y CDATA #IMPLIED>\n");
        result.append("  <!ATTLIST pointworld z CDATA #IMPLIED>\n");
        result.append("]>\n\n");
        result.append("<namedpointset version=\"1.0\">\n");
        for (NamedPointWorld p : this.pointsWorld) {
            result.append("  ");
            result.append(p.toXMLElement());
            result.append("\n");
        }
        result.append("</namedpointset>\n");
        return result.toString();
    }

    public byte[] xmlDataAsBytes() {
        try {
            return this.xmlDataAsString().getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            IJ.error((String)"UTF-8 isn't available (!)");
            return null;
        }
    }

    public boolean saveIGSPointsFile(String savePath) {
        try {
            FileOutputStream fos = new FileOutputStream(savePath);
            StringBuffer sb = new StringBuffer("! TYPEDSTREAM 1.1\n");
            ListIterator i = this.listIterator();
            while (i.hasNext()) {
                NamedPointWorld p = (NamedPointWorld)i.next();
                if (!p.set) continue;
                sb.append(p.toIGS() + "\n");
            }
            fos.write(sb.toString().getBytes("UTF-8"));
            fos.close();
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(NamedPointWorld namedPointWorld) {
        NamedPointSet namedPointSet = this;
        synchronized (namedPointSet) {
            String name = namedPointWorld.getName();
            NamedPointWorld existing = this.get(name);
            if (existing != null) {
                throw new RuntimeException("Trying to add a point of name '" + name + "', but this NamedPointSet already has one.");
            }
            this.pointsWorld.add(namedPointWorld);
        }
    }

    public static NamedPointSet forImage(ImagePlus imagePlus) throws PointsFileException {
        FileInfo info = imagePlus.getOriginalFileInfo();
        if (info == null) {
            throw new PointsFileException("Could not find original file for the image: " + imagePlus.getTitle());
        }
        String fileName = info.fileName;
        String url = info.url;
        String directory = info.directory;
        File f = new File(directory, fileName);
        return NamedPointSet.forImage(imagePlus, f.getAbsolutePath());
    }

    public static NamedPointSet forImage(String imageFilename) throws PointsFileException {
        return NamedPointSet.forImage(null, imageFilename);
    }

    public static NamedPointSet forImage(ImagePlus imagePlus, String imageFilename) throws PointsFileException {
        String[] possibleExtensions = new String[]{".points.xml", ".points.R", ".points"};
        int lastDot = imageFilename.lastIndexOf(".");
        String withoutExtension = null;
        if (lastDot >= 0) {
            withoutExtension = imageFilename.substring(0, lastDot);
        }
        for (String extension : possibleExtensions) {
            for (int i = 0; i < 2; ++i) {
                String candidateFilename = null;
                if (i == 0 && lastDot >= 0) {
                    candidateFilename = withoutExtension + extension;
                } else if (i == 1) {
                    candidateFilename = imageFilename + extension;
                }
                try {
                    return NamedPointSet.fromFile(candidateFilename, imagePlus, imageFilename);
                }
                catch (PointsFileException pointsFileException) {
                    continue;
                }
            }
        }
        throw new PointsFileException("None of the points filenames corresponding to '" + imageFilename + "' could be loaded.");
    }

    public static NamedPointSet fromFile(String pointsFilename) throws PointsFileException {
        return NamedPointSet.fromFile(pointsFilename, null, null);
    }

    public static NamedPointSet fromFile(String pointsFilename, ImagePlus imagePlus, String imageFilename) throws PointsFileException {
        File f = new File(pointsFilename);
        if (!f.exists()) {
            throw new PointsFileException("File not found: " + pointsFilename);
        }
        return NamedPointSet.fromFile(f, imagePlus, imageFilename);
    }

    public static NamedPointSet fromFile(File f) throws PointsFileException {
        return NamedPointSet.fromFile(f, null, null);
    }

    public static NamedPointSet fromFile(File f, ImagePlus imagePlus, String imageFilename) throws PointsFileException {
        try {
            return NamedPointSet.fromBufferedReader(new BufferedReader(new FileReader(f)), imagePlus, imageFilename);
        }
        catch (FileNotFoundException e) {
            throw new PointsFileException("Couldn't find the file: " + f.getAbsolutePath());
        }
    }

    public static NamedPointSet fromString(String s) {
        return NamedPointSet.fromString(s);
    }

    public static NamedPointSet fromString(String s, ImagePlus imagePlus, String imageFilename) throws PointsFileException {
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setValidating(true);
            SAXParser parser = factory.newSAXParser();
            StringReader reader = new StringReader(s);
            InputSource inputSource = new InputSource(reader);
            NamedPointSet nps = new NamedPointSet();
            Handler h = new Handler(nps);
            parser.parse(inputSource, (DefaultHandler)h);
            reader.close();
            return nps;
        }
        catch (ParserConfigurationException e) {
            throw new PointsFileException("There was a ParserConfigurationException when trying to parse as XML: " + e);
        }
        catch (SAXException e) {
        }
        catch (FileNotFoundException e) {
            throw new PointsFileException("BUG: FileNotFoundException while parsing XML from a String: " + e);
        }
        catch (IOException e) {
            throw new PointsFileException("BUG: IOException while parsing XML from a String: " + e);
        }
        try {
            NamedPointSet nps = new NamedPointSet();
            Pattern emptyPattern = Pattern.compile("^ *$");
            Pattern numberPattern = Pattern.compile("[eE0-9\\.\\-]+");
            StringReader sr = new StringReader(s);
            CSVReader tsvReader = new CSVReader(sr, '\t');
            List l = tsvReader.readAll();
            for (String[] a : l) {
                boolean set;
                if (a.length != 4) {
                    throw new PointsFileException("There must be 4 fields per line of the tab-separated values file");
                }
                String xString = a[0];
                String yString = a[1];
                String zString = a[2];
                String name = a[3];
                Matcher emptyXMatcher = emptyPattern.matcher(xString);
                Matcher emptyYMatcher = emptyPattern.matcher(yString);
                Matcher emptyZMatcher = emptyPattern.matcher(zString);
                Matcher numberXMatcher = numberPattern.matcher(xString);
                Matcher numberYMatcher = numberPattern.matcher(yString);
                Matcher numberZMatcher = numberPattern.matcher(zString);
                if (emptyXMatcher.matches() && emptyYMatcher.matches() && emptyZMatcher.matches()) {
                    set = false;
                } else if (numberXMatcher.matches() && numberYMatcher.matches() && numberZMatcher.matches()) {
                    set = true;
                } else {
                    throw new PointsFileException("In tab-separated format, the first three columns must all be empty or all be numbers");
                }
                if (set) {
                    double x = Double.parseDouble(xString);
                    double y = Double.parseDouble(yString);
                    double z = Double.parseDouble(zString);
                    nps.add(new NamedPointWorld(name, x, y, z));
                    continue;
                }
                nps.add(new NamedPointWorld(name));
            }
            return nps;
        }
        catch (PointsFileException nps) {
        }
        catch (IOException nps) {
        }
        catch (NumberFormatException nps) {
            // empty catch block
        }
        try {
            String[] lines;
            ImagePlus loadedImagePlus;
            NamedPointSet nps = new NamedPointSet();
            Pattern p_data = Pattern.compile("^\"(.*)\": *\\[ *([eE0-9\\.\\-]+) *, *([eE0-9\\.\\-]+) *, *([eE0-9\\.\\-]+) *\\] *$");
            Pattern p_comment = Pattern.compile("^ *#.*$");
            Pattern p_name_no_data = Pattern.compile("^\"(.*)\":.*$");
            Calibration c = null;
            if (imagePlus != null) {
                c = imagePlus.getCalibration();
            } else if (imageFilename != null && (loadedImagePlus = BatchOpener.openFirstChannel(imageFilename)) != null) {
                c = loadedImagePlus.getCalibration();
                loadedImagePlus.close();
            }
            double xSpacing = 1.0;
            double ySpacing = 1.0;
            double zSpacing = 1.0;
            if (c != null) {
                xSpacing = c.pixelWidth;
                ySpacing = c.pixelHeight;
                zSpacing = c.pixelDepth;
            }
            for (String line : lines = s.split("[\\r\\n]+")) {
                if ((line = line.trim()).length() == 0) continue;
                Matcher m_data = p_data.matcher(line);
                Matcher m_comment = p_comment.matcher(line);
                Matcher m_name_no_data = p_name_no_data.matcher(line);
                if (m_data.matches()) {
                    nps.add(new NamedPointWorld(m_data.group(1), Double.parseDouble(m_data.group(2)) * xSpacing, Double.parseDouble(m_data.group(3)) * ySpacing, Double.parseDouble(m_data.group(4)) * zSpacing));
                    continue;
                }
                if (m_name_no_data.matches()) {
                    nps.add(new NamedPointWorld(m_name_no_data.group(1)));
                    continue;
                }
                if (m_comment.matches()) continue;
                throw new PointsFileException("Couldn't parse the points file; the problematic line is '" + line + "'");
            }
            if (c == null) {
                IJ.error((String)"Warning: no calibration data found for a pseudo-YAML points file; assuming that voxel spacing is ( 1, 1, 1 )");
            }
            return nps;
        }
        catch (NumberFormatException e) {
            throw new PointsFileException("Failed to load the points file by any method; the last error was: " + e);
        }
        catch (PointsFileException e) {
            throw new PointsFileException("Failed to load the points file by any method; the last error was: " + e);
        }
    }

    public static NamedPointSet fromBufferedReader(BufferedReader br, ImagePlus imagePlus, String imageFilename) throws PointsFileException {
        StringBuffer result = new StringBuffer("");
        String line = null;
        try {
            while (true) {
                if ((line = br.readLine()) == null) {
                    return NamedPointSet.fromString(result.toString(), imagePlus, imageFilename);
                }
                result.append(line);
                result.append("\n");
            }
        }
        catch (IOException e) {
            throw new PointsFileException("There was an IOException while reading points file data: " + e);
        }
    }

    public ArrayList<String> namesSharedWith(NamedPointSet other) {
        return this.namesSharedWith(other, false);
    }

    public ArrayList<String> namesSharedWith(NamedPointSet other, boolean onlySetPoints) {
        ArrayList<String> common = new ArrayList<String>();
        block0: for (NamedPointWorld iNPW : this.pointsWorld) {
            String pointName = iNPW.name;
            for (NamedPointWorld jNPQ : other.pointsWorld) {
                if ((!iNPW.set || !jNPQ.set) && onlySetPoints || !pointName.equals(jNPQ.name)) continue;
                common.add(new String(pointName));
                continue block0;
            }
        }
        return common;
    }

    public Point3d[] getPoint3DArrayForNames(String[] names) {
        Point3d[] result = new Point3d[names.length];
        for (int i = 0; i < names.length; ++i) {
            NamedPointWorld np = this.get(names[i]);
            if (np == null) {
                return null;
            }
            result[i] = new Point3d(np.x, np.y, np.z);
        }
        return result;
    }

    public Set<String> getNamesAsSet() {
        HashSet<String> namesSet = new HashSet<String>();
        for (NamedPointWorld npw : this.pointsWorld) {
            namesSet.add(npw.getName());
        }
        return namesSet;
    }

    public boolean equals(NamedPointSet other) {
        Set<String> otherNames;
        Set<String> thisNames = this.getNamesAsSet();
        if (!thisNames.equals(otherNames = other.getNamesAsSet())) {
            return false;
        }
        double epsilon = 1.0E-5;
        for (String name : thisNames) {
            NamedPointWorld thisNPW = this.get(name);
            NamedPointWorld otherNPW = other.get(name);
            if (thisNPW.set != otherNPW.set) {
                return false;
            }
            if (!thisNPW.set) continue;
            if (Math.abs(thisNPW.x - otherNPW.x) > epsilon) {
                return false;
            }
            if (Math.abs(thisNPW.y - otherNPW.y) > epsilon) {
                return false;
            }
            if (!(Math.abs(thisNPW.z - otherNPW.z) > epsilon)) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        for (NamedPointWorld npw : this.pointsWorld) {
            sb.append(npw.toString());
            sb.append("\n");
        }
        return sb.toString();
    }

    public synchronized boolean renamePointTo(int i, String newName) {
        NamedPointWorld existing = this.get(newName);
        if (existing == null) {
            this.pointsWorld.get(i).setName(newName);
            return true;
        }
        return false;
    }

    public synchronized NamedPointWorld addNewPoint() {
        int i = this.pointsWorld.size();
        boolean nameTaken = true;
        String newName = null;
        while (nameTaken) {
            newName = "Named Point (" + i + ")";
            nameTaken = this.get(newName) != null;
            ++i;
        }
        NamedPointWorld toAdd = new NamedPointWorld(newName);
        this.pointsWorld.add(toAdd);
        return toAdd;
    }

    void unset(int i) {
        NamedPointWorld npw = this.pointsWorld.get(i);
        npw.unset();
    }

    public static class PointsFileException
    extends Exception {
        PointsFileException(String message) {
            super(message);
        }
    }

    private static class Handler
    extends DefaultHandler {
        protected NamedPointSet nps;
        String version = "";

        public Handler(NamedPointSet nps) {
            this.nps = nps;
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if (qName.equals("namedpointset")) {
                this.version = attributes.getValue("version");
                if (this.version == null) {
                    throw new SAXException("No 'version' attribute in <namedpointset>");
                }
            }
            if (qName.equals("pointworld")) {
                boolean set;
                String setString = attributes.getValue("set");
                String nameString = attributes.getValue("name");
                String xString = attributes.getValue("x");
                String yString = attributes.getValue("y");
                String zString = attributes.getValue("z");
                if (setString == null) {
                    throw new SAXException("No 'set' attribute in <pointworld>");
                }
                if (setString.equals("true")) {
                    set = true;
                } else if (setString.equals("false")) {
                    set = false;
                } else {
                    throw new SAXException("The 'set' attribute must be 'true' or 'false'");
                }
                if (nameString == null) {
                    throw new SAXException("No 'name' attribute in <pointworld");
                }
                String name = nameString;
                if (set && (xString == null || yString == null || zString == null)) {
                    throw new SAXException("If 'set' is true then all of 'x', 'y' and 'z' must be specified.");
                }
                if (!(set || xString == null && yString == null && zString == null)) {
                    throw new SAXException("If 'set' is false then none of 'x', 'y' or 'z' may be specified.");
                }
                double x = -1.0;
                double y = -1.0;
                double z = -1.0;
                if (set) {
                    try {
                        x = Double.parseDouble(xString);
                        y = Double.parseDouble(yString);
                        z = Double.parseDouble(zString);
                        this.nps.add(new NamedPointWorld(name, x, y, z));
                    }
                    catch (NumberFormatException e) {
                        throw new SAXException("One of 'x', 'y' and 'z' couldn't be parsed as a number");
                    }
                } else {
                    this.nps.add(new NamedPointWorld(name));
                }
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
        }
    }
}

