/*
 * Decompiled with CFR 0.152.
 */
package landmarks;

import ij.ImagePlus;
import ij.measure.Calibration;
import landmarks.FineTuneProgressListener;
import landmarks.NamePoints;
import landmarks.NamedPointWorld;
import landmarks.ProgressWindow;
import landmarks.RegistrationResult;
import pal.math.MultivariateFunction;

public class TransformationAttempt
implements MultivariateFunction {
    double cubeSide;
    ImagePlus croppedTemplate;
    NamedPointWorld templatePoint;
    ImagePlus newImage;
    NamedPointWorld guessedPoint;
    ProgressWindow progressWindow;
    double minTranslation;
    double maxTranslation;
    int similarityMeasure;
    FineTuneProgressListener listener;

    public TransformationAttempt(double cubeSide, ImagePlus croppedTemplate, NamedPointWorld templatePoint, ImagePlus newImage, NamedPointWorld guessedPoint, int similarityMeasure, FineTuneProgressListener listener, ProgressWindow progressWindow) {
        this.cubeSide = cubeSide;
        this.croppedTemplate = croppedTemplate;
        this.templatePoint = templatePoint;
        this.newImage = newImage;
        this.guessedPoint = guessedPoint;
        this.listener = listener;
        this.progressWindow = progressWindow;
        this.similarityMeasure = similarityMeasure;
        this.minTranslation = -cubeSide;
        Calibration c = newImage.getCalibration();
        this.maxTranslation = 0.0;
        double max_x = (double)newImage.getWidth() * c.pixelWidth;
        double max_y = (double)newImage.getHeight() * c.pixelHeight;
        double max_z = (double)newImage.getStackSize() * c.pixelDepth;
        if (max_x > this.maxTranslation) {
            this.maxTranslation = max_x;
        }
        if (max_y > this.maxTranslation) {
            this.maxTranslation = max_y;
        }
        if (max_z > this.maxTranslation) {
            this.maxTranslation = max_z;
        }
        this.maxTranslation += cubeSide;
    }

    @Override
    public double evaluate(double[] argument) {
        RegistrationResult r = NamePoints.mapImageWith(this.croppedTemplate, this.newImage, this.templatePoint, this.guessedPoint, argument, this.cubeSide, this.similarityMeasure, "");
        if (this.listener != null) {
            this.listener.fineTuneNewBestResult(r);
        }
        return r.score;
    }

    @Override
    public int getNumArguments() {
        return 6;
    }

    @Override
    public double getLowerBound(int n) {
        if (n >= 0 && n <= 2) {
            return Math.PI * -4;
        }
        return this.minTranslation;
    }

    @Override
    public double getUpperBound(int n) {
        if (n >= 0 && n <= 2) {
            return Math.PI * 4;
        }
        return this.maxTranslation;
    }
}

