/*
 * Decompiled with CFR 0.152.
 */
package util;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.gui.GenericDialog;
import ij.plugin.PlugIn;
import ij.process.ByteProcessor;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import java.awt.Panel;
import java.io.File;
import java.util.Arrays;
import java.util.regex.Pattern;
import process3d.DistanceTransform3D;
import util.BatchOpener;
import util.ImageCalculatorRevised;
import vib.app.FileGroup;
import vib.app.gui.FileGroupDialog;

public class RohlfingSBA
implements PlugIn {
    private FileGroup fg;
    private ImagePlus D_min;
    private ImagePlus output;
    private int w;
    private int h;
    private int d;
    private int L;
    private int K;

    public void run(String arg) {
        Pattern macOSPattern = Pattern.compile("^Mac ?OS.*$", 2);
        String osName = (String)System.getProperties().get("os.name");
        if (osName != null && macOSPattern.matcher(osName).matches()) {
            IJ.error((String)"The Shaped-Based Averaging plugin is currently disabled on Mac OS due to Bug 29.");
            return;
        }
        GenericDialog gd = new GenericDialog("Rohlfing");
        this.fg = new FileGroup("files");
        FileGroupDialog fgd = new FileGroupDialog(this.fg, false);
        gd.addPanel((Panel)fgd);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return;
        }
        this.init();
        this.doit();
    }

    ImagePlus calculate(ImagePlus a, String operation, ImagePlus b) {
        String parameter = operation + " 32 stack";
        ImageCalculatorRevised calculator = new ImageCalculatorRevised();
        return calculator.calculateResult(parameter, a, b);
    }

    public void setFileGroup(FileGroup fg) {
        this.fg = fg;
    }

    public ImagePlus doit() {
        ImagePlus D = null;
        IJ.showProgress((double)0.0);
        for (int l = 0; l < this.L; ++l) {
            System.out.println("At level " + l);
            for (int k = 0; k < this.K; ++k) {
                System.out.println("  Doing image " + k);
                if (D == null) {
                    D = this.d_kl(l, k);
                } else {
                    ImagePlus tmp = this.d_kl(l, k);
                    ImagePlus result = this.calculate(D, "add", tmp);
                    D.close();
                    tmp.close();
                    D = result;
                }
                IJ.showProgress((double)((double)(l * this.K + k) / (double)(this.L * this.K)));
            }
            for (int z = 0; z < this.d; ++z) {
                D.getStack().getProcessor(z + 1).multiply(1.0 / (double)this.K);
                float[] D_p = (float[])D.getStack().getProcessor(z + 1).getPixels();
                float[] D_minp = (float[])this.D_min.getStack().getProcessor(z + 1).getPixels();
                byte[] output_p = (byte[])this.output.getStack().getProcessor(z + 1).getPixels();
                for (int i = 0; i < this.w * this.h; ++i) {
                    if (!(D_p[i] < D_minp[i])) continue;
                    output_p[i] = (byte)l;
                    D_minp[i] = D_p[i];
                }
            }
        }
        IJ.showProgress((double)1.0);
        this.output.show();
        return this.output;
    }

    private ImagePlus d_kl(int l, int k) {
        File file = (File)this.fg.get(k);
        ImagePlus image = BatchOpener.openFirstChannel(file.getAbsolutePath());
        ImagePlus binary = this.createBinary(image, l);
        image.close();
        ImagePlus im1 = new DistanceTransform3D().getTransformed(binary, 0);
        ImagePlus im2 = new DistanceTransform3D().getTransformed(binary, 255);
        binary.close();
        ImagePlus result = this.calculate(im2, "sub", im1);
        im1.close();
        im2.close();
        return result;
    }

    private ImagePlus createBinary(ImagePlus image, int value) {
        int w = image.getWidth();
        int h = image.getWidth();
        int d = image.getStackSize();
        ImageStack stack = new ImageStack(w, h);
        for (int z = 0; z < d; ++z) {
            byte[] f = new byte[w * h];
            byte[] p = (byte[])image.getStack().getProcessor(z + 1).getPixels();
            for (int i = 0; i < w * h; ++i) {
                f[i] = (p[i] & 0xFF) == value ? -1 : 0;
            }
            stack.addSlice("", (ImageProcessor)new ByteProcessor(w, h, f, null));
        }
        return new ImagePlus("Label_" + (value & 0xFF), stack);
    }

    public void init() {
        int z;
        File file = (File)this.fg.get(0);
        ImagePlus image = BatchOpener.openFirstChannel(file.getAbsolutePath());
        this.w = image.getWidth();
        this.h = image.getHeight();
        this.d = image.getStackSize();
        image.close();
        this.L = 256;
        this.K = this.fg.size();
        ImageStack stack = new ImageStack(this.w, this.h);
        for (z = 0; z < this.d; ++z) {
            stack.addSlice("", (ImageProcessor)new ByteProcessor(this.w, this.h));
        }
        this.output = new ImagePlus("Output", stack);
        stack = new ImageStack(this.w, this.h);
        for (z = 0; z < this.d; ++z) {
            float[] f = new float[this.w * this.h];
            Arrays.fill(f, Float.MAX_VALUE);
            stack.addSlice("", (ImageProcessor)new FloatProcessor(this.w, this.h, f, null));
        }
        this.D_min = new ImagePlus("D_min", stack);
    }
}

