/*
 * Decompiled with CFR 0.152.
 */
package io.scif;

import io.scif.AbstractPlane;
import io.scif.ImageMetadata;
import io.scif.util.FormatTools;
import net.imglib2.Interval;
import org.scijava.util.ArrayUtils;

public class ByteArrayPlane
extends AbstractPlane<byte[], ByteArrayPlane> {
    public ByteArrayPlane() {
    }

    public ByteArrayPlane(ImageMetadata meta, Interval bounds) {
        super(meta, bounds);
    }

    @Override
    public byte[] getBytes() {
        return (byte[])this.getData();
    }

    @Override
    protected byte[] blankPlane(Interval bounds) {
        byte[] buf = null;
        long[] sizes = new long[bounds.numDimensions() + 1];
        for (int i = 0; i < sizes.length - 1; ++i) {
            sizes[i] = bounds.dimension(i);
        }
        sizes[sizes.length - 1] = FormatTools.getBytesPerPixel(this.getImageMetadata().getPixelType());
        buf = ArrayUtils.allocate((long[])sizes);
        return buf;
    }
}

