/*
 * Decompiled with CFR 0.152.
 */
package io.scif.formats.tiff;

import io.scif.formats.tiff.IFDType;

public class TiffIFDEntry
implements Comparable<Object> {
    private final int tag;
    private final IFDType type;
    private final int valueCount;
    private final long valueOffset;

    public TiffIFDEntry(int tag, IFDType type, int valueCount, long valueOffset) {
        this.tag = tag;
        this.type = type;
        this.valueCount = valueCount;
        this.valueOffset = valueOffset;
    }

    public int getTag() {
        return this.tag;
    }

    public IFDType getType() {
        return this.type;
    }

    public int getValueCount() {
        return this.valueCount;
    }

    public long getValueOffset() {
        return this.valueOffset;
    }

    public String toString() {
        return "tag = " + this.tag + ", type = " + this.type + ", count = " + this.valueCount + ", offset = " + this.valueOffset;
    }

    @Override
    public int compareTo(Object o) {
        if (!(o instanceof TiffIFDEntry)) {
            return 1;
        }
        long offset = ((TiffIFDEntry)o).getValueOffset();
        if (offset == this.getValueOffset()) {
            return 0;
        }
        return offset < this.getValueOffset() ? 1 : -1;
    }
}

