/*
 * Decompiled with CFR 0.152.
 */
package io.scif.img.cell.loaders;

import io.scif.ImageMetadata;
import io.scif.Reader;
import io.scif.img.ImageRegion;
import io.scif.img.cell.loaders.AbstractArrayLoader;
import io.scif.util.FormatTools;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import net.imglib2.img.basictypeaccess.array.DoubleArray;
import net.imglib2.type.numeric.real.DoubleType;

public class DoubleArrayLoader
extends AbstractArrayLoader<DoubleArray> {
    public DoubleArrayLoader(Reader reader, ImageRegion subRegion) {
        super(reader, subRegion);
    }

    @Override
    public void convertBytes(DoubleArray data, byte[] bytes, int planesRead) {
        ImageMetadata iMeta = this.reader().getMetadata().get(0);
        if (this.isCompatible()) {
            int bpp = this.getBitsPerElement() / 8;
            int offset = planesRead * (bytes.length / bpp);
            ByteBuffer bb = ByteBuffer.wrap(bytes);
            bb.order(iMeta.isLittleEndian() ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN);
            bb.asDoubleBuffer().get(data.getCurrentStorageArray(), offset, bytes.length / bpp);
        } else {
            int pixelType = iMeta.getPixelType();
            int bpp = FormatTools.getBytesPerPixel(pixelType);
            int offset = planesRead * (bytes.length / bpp);
            for (int index = 0; index < bytes.length / bpp; ++index) {
                double value = this.utils().decodeWord(bytes, index * bpp, pixelType, iMeta.isLittleEndian());
                data.setValue(offset + index, value);
            }
        }
    }

    @Override
    public DoubleArray emptyArray(int entities) {
        return new DoubleArray(entities);
    }

    @Override
    public int getBitsPerElement() {
        return 64;
    }

    @Override
    public Class<?> outputClass() {
        return DoubleType.class;
    }
}

