/*
 * Decompiled with CFR 0.152.
 */
package org.janelia.thickness.lut;

import net.imglib2.RandomAccessibleInterval;
import net.imglib2.RealLocalizable;
import net.imglib2.RealPositionable;
import net.imglib2.realtransform.InverseRealTransform;
import net.imglib2.realtransform.InvertibleRealTransform;
import net.imglib2.type.numeric.real.DoubleType;
import org.janelia.thickness.lut.AbstractLUTGrid;

public class SingleDimensionLUTGrid
extends AbstractLUTGrid {
    private final int applyTransformToDimension;

    public SingleDimensionLUTGrid(int numSourceDimensions, int numTargetDimensions, RandomAccessibleInterval<DoubleType> lutArray, int applyTransformToDimension) {
        this(numSourceDimensions, numTargetDimensions, lutArray, applyTransformToDimension, new double[]{1.0}, new double[]{0.0});
    }

    public SingleDimensionLUTGrid(int numSourceDimensions, int numTargetDimensions, RandomAccessibleInterval<DoubleType> lutArray, int applyTransformToDimension, double[] scale, double[] shift) {
        super(numSourceDimensions, numTargetDimensions, lutArray, scale, shift);
        this.applyTransformToDimension = applyTransformToDimension;
        assert (this.applyTransformToDimension >= this.nNonTransformedCoordinates);
    }

    public void apply(double[] source, double[] target) {
        this.updateCoordinates(source);
        for (int d = 0; d < this.nNonTransformedCoordinates; ++d) {
            target[d] = source[d];
        }
        target[this.applyTransformToDimension] = this.applyChecked(source[this.applyTransformToDimension]);
    }

    public void apply(float[] source, float[] target) {
        this.updateCoordinates(source);
        for (int d = 0; d < this.nNonTransformedCoordinates; ++d) {
            target[d] = source[d];
        }
        target[this.applyTransformToDimension] = (float)this.applyChecked(source[this.applyTransformToDimension]);
    }

    public void apply(RealLocalizable source, RealPositionable target) {
        this.updateCoordinates(source);
        for (int d = 0; d < this.nNonTransformedCoordinates; ++d) {
            target.setPosition(source.getDoublePosition(d), d);
        }
        target.setPosition(this.apply(source.getDoublePosition(this.applyTransformToDimension)), this.applyTransformToDimension);
    }

    public void applyInverse(double[] source, double[] target) {
        this.updateCoordinates(target);
        for (int d = 0; d < this.nNonTransformedCoordinates; ++d) {
            source[d] = target[d];
        }
        source[this.applyTransformToDimension] = this.applyInverseChecked(target[this.applyTransformToDimension]);
    }

    public void applyInverse(float[] source, float[] target) {
        this.updateCoordinates(target);
        for (int d = 0; d < this.nNonTransformedCoordinates; ++d) {
            source[d] = target[d];
        }
        source[this.applyTransformToDimension] = (float)this.applyInverseChecked(target[this.applyTransformToDimension]);
    }

    public void applyInverse(RealPositionable source, RealLocalizable target) {
        this.updateCoordinates(target);
        for (int d = 0; d < this.nNonTransformedCoordinates; ++d) {
            source.setPosition(target.getDoublePosition(d), d);
        }
        source.setPosition(this.applyInverseChecked(target.getDoublePosition(this.applyTransformToDimension)), this.applyTransformToDimension);
    }

    public InvertibleRealTransform inverse() {
        return new InverseRealTransform((InvertibleRealTransform)this);
    }

    public InvertibleRealTransform copy() {
        return new SingleDimensionLUTGrid(this.applyTransformToDimension, this.applyTransformToDimension, (RandomAccessibleInterval<DoubleType>)this.lutArray, this.applyTransformToDimension, this.scale, this.shift);
    }

    public SingleDimensionLUTGrid reScale(double ... scale) {
        int i;
        double[] sc = new double[this.scale.length];
        for (i = 0; i < scale.length; ++i) {
            sc[i] = scale[i];
        }
        for (i = scale.length; i < sc.length; ++i) {
            sc[i] = scale[scale.length - 1];
        }
        return new SingleDimensionLUTGrid(this.applyTransformToDimension, this.applyTransformToDimension, (RandomAccessibleInterval<DoubleType>)this.lutArray, this.applyTransformToDimension, sc, this.shift);
    }

    public SingleDimensionLUTGrid reShift(double ... shift) {
        int i;
        double[] sh = new double[this.shift.length];
        for (i = 0; i < shift.length; ++i) {
            sh[i] = shift[i];
        }
        for (i = shift.length; i < sh.length; ++i) {
            sh[i] = shift[shift.length - 1];
        }
        return new SingleDimensionLUTGrid(this.applyTransformToDimension, this.applyTransformToDimension, (RandomAccessibleInterval<DoubleType>)this.lutArray, this.applyTransformToDimension, this.scale, sh);
    }
}

