/*
 * Decompiled with CFR 0.152.
 */
package edu.utexas.clm.archipelago.network.shell.ssh;

import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.UserInfo;
import edu.utexas.clm.archipelago.FijiArchipelago;
import edu.utexas.clm.archipelago.exception.ShellExecutionException;
import edu.utexas.clm.archipelago.listen.NodeShellListener;
import edu.utexas.clm.archipelago.network.node.NodeParameters;
import edu.utexas.clm.archipelago.network.shell.ssh.NodeShellUserInfo;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;

public class JSchUtility
extends Thread {
    private final NodeShellListener listener;
    private final Session session;
    private final Channel channel;
    private final long node;

    public JSchUtility(NodeParameters param, NodeShellListener listener, String command) throws ShellExecutionException, JSchException {
        FijiArchipelago.debug("Creating JSchUtility to run " + command + " on " + param.getHost());
        try {
            JSch jsch = new JSch();
            NodeShellUserInfo ui = new NodeShellUserInfo();
            int port = param.getShellParams().getInteger("ssh-port");
            String keyfile = param.getShellParams().getString("keyfile");
            this.listener = listener;
            this.node = param.getID();
            jsch.addIdentity(new File(keyfile).getAbsolutePath());
            this.session = jsch.getSession(param.getUser(), param.getHost(), port);
            this.session.setUserInfo((UserInfo)ui);
            FijiArchipelago.debug("Connecting session for " + param.getHost());
            this.session.connect();
            FijiArchipelago.debug("Opening a channel on " + param.getHost());
            this.channel = this.session.openChannel("exec");
            FijiArchipelago.debug("Channel opened on " + param.getHost());
            ((ChannelExec)this.channel).setCommand(command);
            ((ChannelExec)this.channel).setErrStream((OutputStream)System.err);
        }
        catch (JSchException jse) {
            throw jse;
        }
        catch (Exception e) {
            FijiArchipelago.debug("Ran into a problem while logging into  " + param.getHost() + ": " + e);
            Thread.dumpStack();
            throw new ShellExecutionException(e);
        }
    }

    public Channel getChannel() {
        return this.channel;
    }

    @Override
    public void run() {
        String host = "";
        try {
            host = this.channel.getSession().getHost();
            FijiArchipelago.debug(host + ": connecting channel");
            this.channel.connect();
            FijiArchipelago.debug(host + ": connect() returned");
            while (this.channel.isConnected()) {
                Thread.sleep(1000L);
            }
            FijiArchipelago.debug(host + ": channel disconnected");
            this.listener.execFinished(this.node, null, this.channel.getExitStatus());
        }
        catch (JSchException jse) {
            FijiArchipelago.debug(host + ": ", jse);
            this.listener.execFinished(this.node, (Exception)((Object)jse), -1);
        }
        catch (InterruptedException ie) {
            FijiArchipelago.debug(host + ": Interrupted");
            this.listener.execFinished(this.node, ie, -1);
        }
        this.channel.disconnect();
        this.session.disconnect();
    }

    public static boolean verifyParameters(NodeParameters param, String file) throws ShellExecutionException, JSchException {
        final AtomicInteger result = new AtomicInteger(-1);
        final ReentrantLock lock = new ReentrantLock();
        final Thread t = Thread.currentThread();
        FijiArchipelago.debug("JSchUtility: testing for existence of " + file + " on " + param.getHost());
        NodeShellListener existListener = new NodeShellListener(){

            @Override
            public void execFinished(long nodeID, Exception e, int status) {
                lock.lock();
                result.set(status);
                t.interrupt();
                lock.unlock();
            }

            @Override
            public void ioStreamsReady(InputStream is, OutputStream os) {
            }
        };
        try {
            lock.lock();
            JSchUtility jUtil = new JSchUtility(param, existListener, "test -e " + file);
            jUtil.start();
            lock.unlock();
            Thread.sleep(Long.MAX_VALUE);
            return false;
        }
        catch (InterruptedException ie) {
            FijiArchipelago.debug("Testing for file " + file + " on " + param.getHost() + " resulted in code " + result.get());
            return result.get() == 0;
        }
        catch (JSchException e) {
            lock.unlock();
            throw e;
        }
        catch (ShellExecutionException e) {
            lock.unlock();
            throw e;
        }
    }
}

