/*
 * Decompiled with CFR 0.152.
 */
package org.janelia.saalfeldlab.n5.hdf5;

import ch.systemsx.cisd.hdf5.IHDF5FileLevelReadOnlyHandler;
import ch.systemsx.cisd.hdf5.IHDF5Reader;
import ch.systemsx.cisd.hdf5.hdf5lib.HDFHelper;
import hdf.hdf5lib.H5;
import hdf.hdf5lib.HDF5Constants;
import hdf.hdf5lib.exceptions.HDF5LibraryException;
import hdf.hdf5lib.structs.H5O_info_t;
import java.io.File;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.janelia.saalfeldlab.n5.DataType;

final class N5HDF5Util {
    private N5HDF5Util() {
    }

    static long memTypeId(DataType dataType) {
        switch (dataType) {
            case INT8: {
                return HDF5Constants.H5T_NATIVE_INT8;
            }
            case UINT8: {
                return HDF5Constants.H5T_NATIVE_UINT8;
            }
            case INT16: {
                return HDF5Constants.H5T_NATIVE_INT16;
            }
            case UINT16: {
                return HDF5Constants.H5T_NATIVE_UINT16;
            }
            case INT32: {
                return HDF5Constants.H5T_NATIVE_INT32;
            }
            case UINT32: {
                return HDF5Constants.H5T_NATIVE_UINT32;
            }
            case INT64: {
                return HDF5Constants.H5T_NATIVE_INT64;
            }
            case UINT64: {
                return HDF5Constants.H5T_NATIVE_UINT64;
            }
            case FLOAT32: {
                return HDF5Constants.H5T_NATIVE_FLOAT;
            }
            case FLOAT64: {
                return HDF5Constants.H5T_NATIVE_DOUBLE;
            }
            case STRING: {
                throw new IllegalStateException("MemTypeId for STRING is not defined and should not be queried.");
            }
        }
        throw new IllegalArgumentException();
    }

    static long[] reorderToLong(int[] array) {
        int n = array.length;
        long[] reordered = new long[n];
        for (int i = 0; i < n; ++i) {
            reordered[i] = array[n - i - 1];
        }
        return reordered;
    }

    static long[] reorderMultiplyToLong(long[] in1, int[] in2) {
        int n = in1.length;
        long[] reordered = new long[n];
        for (int i = 0; i < n; ++i) {
            reordered[i] = in1[n - i - 1] * (long)in2[n - i - 1];
        }
        return reordered;
    }

    static class OpenDataSetCache {
        private static final int MAX_OPEN_DATASETS = 48;
        private final IHDF5Reader reader;
        private final long fileId;
        final long numericConversionXferPropertyListID;
        private final Map<String, OpenDataSet> cache;
        private boolean isClosed = false;

        public OpenDataSetCache(IHDF5Reader reader) {
            this.reader = reader;
            long fileAccessPropertyListId = HDF5Constants.H5P_DEFAULT;
            IHDF5FileLevelReadOnlyHandler fileHandler = reader.file();
            boolean performNumericConversions = fileHandler.isPerformNumericConversions();
            File file = fileHandler.getFile();
            H5.H5open();
            this.numericConversionXferPropertyListID = performNumericConversions ? HDFHelper.H5Pcreate_xfer_abort_overflow() : HDFHelper.H5Pcreate_xfer_abort();
            this.fileId = H5.H5Fopen((String)file.getAbsolutePath(), (int)HDF5Constants.H5F_ACC_RDONLY, (long)fileAccessPropertyListId);
            this.cache = new LinkedHashMap<String, OpenDataSet>(48, 0.75f, true){

                @Override
                protected boolean removeEldestEntry(Map.Entry<String, OpenDataSet> eldest) {
                    if (this.size() > 48) {
                        OpenDataSet dataSet = eldest.getValue();
                        if (dataSet != null) {
                            dataSet.close();
                        }
                        return true;
                    }
                    return false;
                }
            };
        }

        private boolean datasetExists(String pathName) {
            if ("".equals(pathName) || "/".equals(pathName)) {
                return false;
            }
            try {
                H5O_info_t info = H5.H5Oget_info_by_name((long)this.fileId, (String)pathName, (int)HDF5Constants.H5O_INFO_BASIC, (long)HDF5Constants.H5P_DEFAULT);
                return info.type == HDF5Constants.H5O_TYPE_DATASET;
            }
            catch (HDF5LibraryException e) {
                return false;
            }
        }

        public synchronized OpenDataSet get(String pathName) {
            OpenDataSet dataSet = this.cache.get(pathName);
            if (dataSet == null && this.datasetExists(pathName)) {
                dataSet = new OpenDataSet(pathName);
                this.cache.put(pathName, dataSet);
            }
            if (dataSet != null) {
                dataSet.retain();
            }
            return dataSet;
        }

        public synchronized void remove(String pathName) {
            OpenDataSet dataSet = this.cache.remove(pathName);
            if (dataSet != null) {
                dataSet.close();
            }
        }

        public synchronized void clear() {
            this.cache.values().forEach(OpenDataSet::close);
            this.cache.clear();
        }

        public synchronized void close() {
            this.clear();
            if (!this.isClosed) {
                this.isClosed = true;
                int status = H5.H5Pclose((long)this.numericConversionXferPropertyListID);
                if (status < 0) {
                    throw new RuntimeException("Error closing property list");
                }
                status = H5.H5Fclose((long)this.fileId);
                if (status < 0) {
                    throw new RuntimeException("Error closing file");
                }
            }
        }

        class OpenDataSet
        implements AutoCloseable {
            private final AtomicInteger refcount = new AtomicInteger(1);
            final long dataSetId;

            public OpenDataSet(String pathName) {
                this.dataSetId = H5.H5Dopen((long)OpenDataSetCache.this.fileId, (String)pathName, (long)HDF5Constants.H5P_DEFAULT);
            }

            public void retain() {
                if (this.refcount.getAndIncrement() <= 0) {
                    throw new IllegalStateException();
                }
            }

            @Override
            public void close() {
                if (this.refcount.decrementAndGet() == 0) {
                    H5.H5Dclose((long)this.dataSetId);
                }
            }
        }
    }
}

