/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.labkit.pixel_classification.gui;

import java.lang.annotation.Annotation;
import org.scijava.InstantiableException;
import org.scijava.plugin.PluginInfo;
import sc.fiji.labkit.pixel_classification.pixel_feature.filter.FeatureOp;
import sc.fiji.labkit.pixel_classification.pixel_feature.settings.FeatureSetting;

public class FeatureInfo {
    private final String label;
    private final Class<? extends FeatureOp> clazz;
    private final boolean hasParameters;

    public FeatureInfo(PluginInfo<FeatureOp> pluginInfo) throws InstantiableException {
        this.label = FeatureInfo.getLabel(pluginInfo);
        this.clazz = pluginInfo.loadClass();
        this.hasParameters = !new FeatureSetting(this.clazz, new Object[0]).parameters().isEmpty();
    }

    public String getName() {
        return this.label;
    }

    public Class<? extends FeatureOp> pluginClass() {
        return this.clazz;
    }

    public boolean hasParameters() {
        return this.hasParameters;
    }

    public boolean isDeprecated() {
        return FeatureInfo.isDeprecated(this.clazz);
    }

    private static boolean isDeprecated(Class<? extends FeatureOp> aClass) {
        for (Annotation annotation : aClass.getAnnotations()) {
            if (!Deprecated.class.equals(annotation.annotationType())) continue;
            return true;
        }
        return false;
    }

    private static String getLabel(PluginInfo<FeatureOp> pluginInfo) throws InstantiableException {
        String label = pluginInfo.getLabel();
        return label.isEmpty() ? pluginInfo.loadClass().getSimpleName() : label;
    }
}

