/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.labkit.pixel_classification.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.StringJoiner;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.scijava.Context;
import org.scijava.module.Module;
import org.scijava.module.ModuleCanceledException;
import org.scijava.module.ModuleException;
import org.scijava.ui.swing.widget.SwingInputHarvester;
import sc.fiji.labkit.pixel_classification.gui.IconResources;
import sc.fiji.labkit.pixel_classification.pixel_feature.settings.FeatureSetting;

public class ParametersRow
extends JPanel {
    private static final ImageIcon DOT_ICON = IconResources.getIcon("dot_icon_16px.png");
    private static final ImageIcon RM_ICON = IconResources.getIcon("minus_icon_16px.png");
    private static final ImageIcon PARAMS_ICON = IconResources.getIcon("params_icon_16px.png");
    private Context context;
    private FeatureSetting featureSetting;
    private JLabel paramsLabel;

    public ParametersRow(Context context, FeatureSetting featureSetting) {
        this.context = context;
        this.featureSetting = featureSetting;
        this.setLayout(new BorderLayout());
        this.initUI();
    }

    private void initUI() {
        JPanel cbPanel = new JPanel();
        cbPanel.setLayout(new FlowLayout(0));
        cbPanel.add(Box.createHorizontalStrut(50));
        this.paramsLabel = new JLabel(this.paramsString(), DOT_ICON, 2);
        cbPanel.add((Component)this.paramsLabel, "West");
        this.add((Component)cbPanel, "West");
        JPanel btnPanel = new JPanel();
        btnPanel.setLayout(new FlowLayout(0));
        JButton editButton = new JButton(PARAMS_ICON);
        editButton.setFocusPainted(false);
        editButton.setMargin(new Insets(0, 0, 0, 0));
        editButton.setContentAreaFilled(false);
        editButton.setBorderPainted(false);
        editButton.setOpaque(false);
        editButton.setToolTipText("Edit filter parameters");
        editButton.addActionListener(this::editParameters);
        btnPanel.add(editButton);
        JButton rmButton = new JButton(RM_ICON);
        rmButton.setFocusPainted(false);
        rmButton.setMargin(new Insets(0, 0, 0, 0));
        rmButton.setContentAreaFilled(false);
        rmButton.setBorderPainted(false);
        rmButton.setOpaque(false);
        rmButton.setToolTipText("Remove filter");
        rmButton.addActionListener(this::remove);
        btnPanel.add(rmButton);
        this.add((Component)btnPanel, "East");
    }

    private void editParameters(ActionEvent e) {
        this.featureSetting = ParametersRow.showParametersDialog(this.context, this.featureSetting);
        this.update();
        this.validate();
        this.repaint();
    }

    private void update() {
        this.paramsLabel.setText(this.paramsString());
        this.paramsLabel.repaint();
    }

    private void remove(ActionEvent e) {
        this.getParent().remove(this);
    }

    private String paramsString() {
        StringJoiner joiner = new StringJoiner(",");
        for (String parameter : this.featureSetting.parameters()) {
            joiner.add(parameter + "=" + this.featureSetting.getParameter(parameter));
        }
        String s = joiner.toString();
        s = s.replace("sigma", "\u03c3");
        s = s.replace("psi", "\u03c8");
        s = s.replace("gamma", "\u03b3");
        return "<html>" + s + "</html>";
    }

    public FeatureSetting getFeatureSetting() {
        return this.featureSetting;
    }

    public static FeatureSetting showParametersDialog(Context context, FeatureSetting op) {
        SwingInputHarvester harvester = new SwingInputHarvester();
        context.inject((Object)harvester);
        try {
            Module module = op.asModule(null);
            harvester.harvest(module);
            return FeatureSetting.fromModule(module);
        }
        catch (ModuleCanceledException e) {
            return op;
        }
        catch (ModuleException e) {
            throw new RuntimeException(e);
        }
    }
}

