/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.labkit.pixel_classification.pixel_feature.settings;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import net.imagej.ops.OpEnvironment;
import net.imagej.ops.OpInfo;
import net.imagej.ops.OpService;
import net.imglib2.util.Cast;
import org.scijava.Context;
import org.scijava.command.Command;
import org.scijava.command.CommandInfo;
import org.scijava.module.Module;
import org.scijava.module.ModuleException;
import org.scijava.module.ModuleItem;
import org.scijava.service.SciJavaService;
import sc.fiji.labkit.pixel_classification.pixel_feature.filter.FeatureOp;
import sc.fiji.labkit.pixel_classification.pixel_feature.settings.GlobalSettings;

public class FeatureSetting {
    private final CommandInfo commandInfo;
    private final Map<String, Object> parameterValues = new HashMap<String, Object>();
    private static final List<String> EXCLUDE = Arrays.asList("in", "out", "globalSettings", "context");

    private FeatureSetting(CommandInfo commandInfo, Function<String, ?> parameterSupplier) {
        this.commandInfo = commandInfo;
        for (String parameter : this.initParameters()) {
            this.parameterValues.put(parameter, parameterSupplier.apply(parameter));
        }
    }

    public FeatureSetting(Class<? extends FeatureOp> featureClass, Object ... args) {
        this(new CommandInfo(featureClass), (String ignore) -> null);
        for (Map.Entry<String, Object> entry : FeatureSetting.argsToMap(args).entrySet()) {
            this.setParameter(entry.getKey(), entry.getValue());
        }
    }

    public FeatureSetting(FeatureSetting featureSetting) {
        this.commandInfo = featureSetting.commandInfo;
        this.parameterValues.putAll(featureSetting.parameterValues);
    }

    private static Map<String, Object> argsToMap(Object[] args) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (args.length % 2 != 0) {
            throw new IllegalArgumentException();
        }
        for (int i = 0; i < args.length; i += 2) {
            Object key = args[i];
            Object value = args[i + 1];
            if (!(key instanceof String)) {
                throw new IllegalArgumentException();
            }
            map.put((String)key, value);
        }
        return map;
    }

    public static FeatureSetting fromClass(Class<? extends FeatureOp> featureClass) {
        try {
            return FeatureSetting.fromModule(new OpInfo(featureClass).cInfo().createModule());
        }
        catch (ModuleException e) {
            throw new RuntimeException(e);
        }
    }

    public static FeatureSetting fromOp(FeatureOp op) {
        CommandInfo commandInfo = new OpInfo(op.getClass()).cInfo();
        Module module = commandInfo.createModule((Command)op);
        return new FeatureSetting(commandInfo, arg_0 -> ((Module)module).getInput(arg_0));
    }

    public static FeatureSetting fromModule(Module module) {
        Object object = module.getDelegateObject();
        if (object instanceof FeatureOp) {
            return FeatureSetting.fromOp((FeatureOp)object);
        }
        throw new IllegalArgumentException();
    }

    public static FeatureSetting copy(FeatureSetting fs) {
        return new FeatureSetting(fs.commandInfo, fs.parameterValues::get);
    }

    public FeatureOp newInstance(Context context, GlobalSettings globalSettings) {
        FeatureOp delegateObject = (FeatureOp)this.asModule(globalSettings).getDelegateObject();
        context.inject((Object)delegateObject);
        delegateObject.setEnvironment((OpEnvironment)context.service(OpService.class));
        delegateObject.initialize();
        return delegateObject;
    }

    public Set<String> parameters() {
        return this.parameterValues.keySet();
    }

    private List<String> initParameters() {
        ArrayList<String> parameters = new ArrayList<String>();
        this.commandInfo.inputs().forEach(mi -> {
            if (this.isParameterValid((ModuleItem<?>)mi)) {
                parameters.add(mi.getName());
            }
        });
        return parameters;
    }

    public <T> void setParameter(String name, T value) {
        if (!this.parameterValues.containsKey(name)) {
            throw new IllegalArgumentException("Invalid parameter key: " + name + " for feature: " + this.commandInfo.getTitle());
        }
        this.parameterValues.put(name, value);
    }

    public Object getParameter(String name) {
        return this.parameterValues.get(name);
    }

    public Type getParameterType(String name) {
        return this.commandInfo.getInput(name).getGenericType();
    }

    public Module asModule(GlobalSettings globalSettings) {
        try {
            Module module = this.commandInfo.createModule();
            for (String parameter : this.parameters()) {
                Object value = this.parameterValues.get(parameter);
                if (value == null) continue;
                module.setInput(parameter, value);
            }
            module.setInput("globalSettings", (Object)globalSettings);
            module.resolveInput("globalSettings");
            module.resolveInput("in");
            module.resolveInput("out");
            return module;
        }
        catch (ModuleException e) {
            throw new RuntimeException(e);
        }
    }

    public String getName() {
        String label = this.commandInfo.getLabel();
        return label.isEmpty() ? this.commandInfo.getPluginClass().getSimpleName() : label;
    }

    public static FeatureSetting fromJson(JsonElement element) {
        JsonObject o = element.getAsJsonObject();
        String className = o.get("class").getAsString();
        className = FeatureSetting.updateDeprecatedPackageNames(className);
        FeatureSetting fs = FeatureSetting.fromClass(FeatureSetting.classForName(className));
        for (String p : fs.parameters()) {
            fs.setParameter(p, new Gson().fromJson(o.get(p), fs.getParameterType(p)));
        }
        return fs;
    }

    private static String updateDeprecatedPackageNames(String className) {
        if (className.startsWith("net.imglib2.trainable_segmention.pixel_feature.filter")) {
            return className.replace("net.imglib2.trainable_segmention.pixel_feature.filter", "sc.fiji.labkit.pixel_classification.pixel_feature.filter.deprecated");
        }
        if (className.startsWith("net.imglib2.trainable_segmentation.pixel_feature.filter")) {
            return className.replace("net.imglib2.trainable_segmentation.pixel_feature.filter", "sc.fiji.labkit.pixel_classification.pixel_feature.filter");
        }
        return className;
    }

    public JsonElement toJsonTree() {
        JsonObject jsonObject = new JsonObject();
        jsonObject.add("class", (JsonElement)new JsonPrimitive(this.commandInfo.getDelegateClassName()));
        for (String parameter : this.parameters()) {
            jsonObject.add(parameter, new Gson().toJsonTree(this.getParameter(parameter), this.getParameterType(parameter)));
        }
        return jsonObject;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof FeatureSetting)) {
            return false;
        }
        FeatureSetting fs = (FeatureSetting)obj;
        return this.pluginClass().equals(fs.pluginClass()) && this.parameterValues.equals(fs.parameterValues);
    }

    public Class<? extends FeatureOp> pluginClass() {
        return (Class)Cast.unchecked((Object)this.commandInfo.getPluginClass());
    }

    public int hashCode() {
        return Objects.hash(this.commandInfo.getPluginClass(), this.parameterValues);
    }

    private boolean isParameterValid(ModuleItem<?> mi) {
        return !EXCLUDE.contains(mi.getName()) && !SciJavaService.class.isAssignableFrom(mi.getType());
    }

    private static Class<? extends FeatureOp> classForName(String className) {
        try {
            Class<?> tClass = Class.forName(className);
            return tClass;
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }
}

