/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.notebook;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import net.imagej.Data;
import net.imagej.Dataset;
import net.imagej.DatasetService;
import net.imagej.display.DataView;
import net.imagej.display.DatasetView;
import net.imagej.display.ImageDisplayService;
import net.imagej.notebook.BeakerX;
import net.imagej.notebook.NotebookService;
import net.imagej.notebook.NotebookTable;
import net.imagej.notebook.mime.MIMEObject;
import net.imagej.ops.OpEnvironment;
import net.imagej.ops.OpService;
import net.imagej.ops.Ops;
import net.imagej.ops.special.inplace.Inplaces;
import net.imglib2.Dimensions;
import net.imglib2.FinalInterval;
import net.imglib2.Interval;
import net.imglib2.RandomAccessible;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.img.Img;
import net.imglib2.type.NativeType;
import net.imglib2.type.numeric.RealType;
import net.imglib2.util.IntervalIndexer;
import net.imglib2.util.Util;
import net.imglib2.view.ExtendedRandomAccessibleInterval;
import net.imglib2.view.IntervalView;
import org.scijava.convert.ConvertService;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import org.scijava.service.AbstractService;
import org.scijava.service.Service;
import org.scijava.util.ClassUtils;

@Plugin(type=Service.class)
public class DefaultNotebookService
extends AbstractService
implements NotebookService {
    @Parameter
    private ConvertService convertService;
    @Parameter
    private ImageDisplayService ids;
    @Parameter
    private DatasetService ds;
    @Parameter
    private OpService ops;

    public void initialize() {
        try {
            BeakerX.register(MIMEObject.class, (map, mimeObj) -> map.put(mimeObj.mimeType(), mimeObj.data()));
            List mimeFriendlyTypes = this.convertService.getInstances().stream().filter(c -> MIMEObject.class.isAssignableFrom(c.getOutputType())).map(c -> c.getInputType()).collect(Collectors.toList());
            for (Class mimeFriendlyType : mimeFriendlyTypes) {
                BeakerX.register(mimeFriendlyType, (map, object) -> {
                    MIMEObject mimeObj = this.mime(object);
                    if (mimeObj != null) {
                        map.put(mimeObj.mimeType(), mimeObj.data());
                    }
                });
            }
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
    }

    @Override
    public Object display(Object source) {
        MIMEObject mimeObj = this.mime(source);
        return mimeObj == null ? source : mimeObj;
    }

    @Override
    public <T extends RealType<T> & NativeType<T>> RandomAccessibleInterval<T> mosaic(int[] gridLayout, RandomAccessibleInterval<T> ... images) {
        int d;
        int numDims = 0;
        for (int i = 0; i < images.length; ++i) {
            numDims = Math.max(numDims, images[i].numDimensions());
        }
        int[] grid = new int[numDims];
        for (int d2 = 0; d2 < numDims; ++d2) {
            grid[d2] = d2 < gridLayout.length ? gridLayout[d2] : 1;
        }
        int[] pos = new int[numDims];
        long[][] extents = new long[numDims][];
        for (int d3 = 0; d3 < numDims; ++d3) {
            extents[d3] = new long[grid[d3]];
        }
        for (int i = 0; i < images.length; ++i) {
            IntervalIndexer.indexToPosition((int)i, (int[])grid, (int[])pos);
            for (d = 0; d < numDims; ++d) {
                if (pos[d] >= grid[d]) continue;
                extents[d][pos[d]] = Math.max(extents[d][pos[d]], images[i].dimension(d));
            }
        }
        long[][] offsets = new long[numDims][];
        for (d = 0; d < numDims; ++d) {
            offsets[d] = new long[grid[d] + 1];
        }
        for (d = 0; d < numDims; ++d) {
            for (int g = 0; g < grid[d]; ++g) {
                offsets[d][g + 1] = offsets[d][g] + extents[d][g];
            }
        }
        long[] mosaicDims = new long[numDims];
        for (int d4 = 0; d4 < numDims; ++d4) {
            mosaicDims[d4] = offsets[d4][offsets[d4].length - 1];
        }
        FinalInterval mosaicBox = new FinalInterval(mosaicDims);
        Img result = this.ops.create().img((Dimensions)mosaicBox, (NativeType)Util.getTypeFromInterval(images[0]));
        for (int i = 0; i < images.length; ++i) {
            IntervalIndexer.indexToPosition((int)i, (int[])grid, (int[])pos);
            boolean outOfBounds = false;
            for (int d5 = 0; d5 < numDims; ++d5) {
                if (pos[d5] < grid[d5]) continue;
                outOfBounds = true;
                break;
            }
            if (outOfBounds) continue;
            long[] offset = new long[numDims];
            for (int d6 = 0; d6 < numDims; ++d6) {
                offset[d6] = offsets[d6][pos[d6]];
            }
            IntervalView translated = this.ops.transform().translateView((RandomAccessibleInterval)this.ops.transform().zeroMinView(images[i]), offset);
            ExtendedRandomAccessibleInterval extended = this.ops.transform().extendZeroView((RandomAccessibleInterval)translated);
            IntervalView expanded = this.ops.transform().intervalView((RandomAccessible)extended, (Interval)mosaicBox);
            Inplaces.binary1((OpEnvironment)this.ops, Ops.Math.Add.class, (Object)result, (Object)expanded, (Object[])new Object[0]).mutate1((Object)result, (Object)expanded);
        }
        return result;
    }

    @Override
    public NotebookTable methods(Class<?> type, String prefix) {
        NotebookTable table = new NotebookTable();
        Method[] methods = type.getMethods();
        Arrays.sort(methods, (m1, m2) -> {
            int pCount2;
            int nameComp = m1.getName().compareTo(m2.getName());
            if (nameComp != 0) {
                return nameComp;
            }
            int pCount1 = m1.getParameterCount();
            if (pCount1 != (pCount2 = m2.getParameterCount())) {
                return pCount1 - pCount2;
            }
            Class<?>[] pTypes1 = m1.getParameterTypes();
            Class<?>[] pTypes2 = m2.getParameterTypes();
            for (int i = 0; i < pTypes1.length; ++i) {
                int typeComp = ClassUtils.compare(pTypes1[i], pTypes2[i]);
                if (typeComp == 0) continue;
                return typeComp;
            }
            return ClassUtils.compare(m1.getReturnType(), m2.getReturnType());
        });
        for (Method m : methods) {
            String name = m.getName();
            if (!name.startsWith(prefix)) continue;
            Class<?>[] paramTypes = m.getParameterTypes();
            List args = Arrays.asList(paramTypes).stream().map(c -> c.getName()).collect(Collectors.toList());
            String arguments = args.toString();
            if ((arguments = arguments.substring(1, arguments.length() - 1)).isEmpty()) {
                arguments = "<none>";
            }
            String returns = m.getReturnType().getName();
            table.addRow("name", name, "arguments", arguments, "returns", returns);
        }
        return table;
    }

    @Override
    public <T extends RealType<T>> DatasetView viewRealType(RandomAccessibleInterval<T> source) {
        Dataset data = this.ds.create(source);
        DataView view = this.ids.createDataView((Data)data);
        if (!(view instanceof DatasetView)) {
            throw new IllegalArgumentException("source image cannot be cast to a DatasetView");
        }
        DatasetView datasetView = (DatasetView)view;
        return datasetView;
    }

    private MIMEObject mime(Object object) {
        return (MIMEObject)this.convertService.convert(object, MIMEObject.class);
    }
}

