/*
 * Decompiled with CFR 0.152.
 */
package features;

import features.HessianEvalueProcessor;
import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.gui.ImageCanvas;
import ij.gui.StackWindow;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Label;
import java.awt.Scrollbar;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.awt.image.ImageObserver;
import stacks.ThreePaneCrop;
import util.Limits;

public class SigmaPalette
extends Thread {
    double[] sigmaValues;
    int croppedWidth;
    int croppedHeight;
    int croppedDepth;
    SigmaPaletteListener listener;
    ImagePlus paletteImage;
    double max;
    int selectedSigmaIndex = -1;
    int x_min;
    int x_max;
    int y_min;
    int y_max;
    int z_min;
    int z_max;
    HessianEvalueProcessor hep;
    double defaultMax;
    int sigmasAcross;
    int sigmasDown;
    int initial_z;
    ImagePlus image;

    public void setListener(SigmaPaletteListener newListener) {
        this.listener = newListener;
    }

    public double getMax() {
        return this.max;
    }

    public void setMax(double max) {
        this.max = max;
        if (this.paletteImage != null) {
            this.paletteImage.getProcessor().setMinAndMax(0.0, max);
            this.paletteImage.updateAndDraw();
        }
        if (this.listener != null) {
            this.listener.newMaximum(max);
        }
    }

    public int getSelectedSigmaIndex() {
        return this.selectedSigmaIndex;
    }

    public void setSelectedSigmaIndex(int selectedSigmaIndex) {
        this.selectedSigmaIndex = selectedSigmaIndex;
        if (this.listener != null && selectedSigmaIndex >= 0) {
            this.listener.newSigmaSelected(this.sigmaValues[selectedSigmaIndex]);
        }
        this.paletteImage.updateAndDraw();
    }

    public void makePalette(ImagePlus image, int x_min, int x_max, int y_min, int y_max, int z_min, int z_max, HessianEvalueProcessor hep, double[] sigmaValues, double defaultMax, int sigmasAcross, int sigmasDown, int initial_z) {
        this.image = image;
        this.x_min = x_min;
        this.x_max = x_max;
        this.y_min = y_min;
        this.y_max = y_max;
        this.z_min = z_min;
        this.z_max = z_max;
        this.hep = hep;
        this.sigmaValues = sigmaValues;
        this.defaultMax = defaultMax;
        this.sigmasAcross = sigmasAcross;
        this.sigmasDown = sigmasDown;
        this.initial_z = initial_z;
        int originalWidth = image.getWidth();
        int originalHeight = image.getHeight();
        int originalDepth = image.getStackSize();
        this.start();
    }

    public void copyIntoPalette(ImagePlus smallImage, ImagePlus paletteImage, int offsetX, int offsetY) {
        int largerWidth = paletteImage.getWidth();
        int largerHeight = paletteImage.getHeight();
        int depth = paletteImage.getStackSize();
        if (depth != smallImage.getStackSize()) {
            throw new RuntimeException("In copyIntoPalette(), depths don't match");
        }
        int smallWidth = smallImage.getWidth();
        int smallHeight = smallImage.getHeight();
        float[] limits = Limits.getStackLimits(smallImage);
        ImageStack paletteStack = paletteImage.getStack();
        ImageStack smallStack = smallImage.getStack();
        for (int z = 0; z < depth; ++z) {
            float[] smallPixels = (float[])smallStack.getProcessor(z + 1).getPixels();
            float[] palettePixels = (float[])paletteStack.getProcessor(z + 1).getPixels();
            for (int y = 0; y < smallHeight; ++y) {
                int smallIndex = y * smallWidth;
                System.arraycopy(smallPixels, smallIndex, palettePixels, (offsetY + y) * largerWidth + offsetX, smallWidth);
            }
        }
    }

    @Override
    public void run() {
        ImagePlus cropped = ThreePaneCrop.performCrop(this.image, this.x_min, this.x_max, this.y_min, this.y_max, this.z_min, this.z_max, false);
        this.croppedWidth = this.x_max - this.x_min + 1;
        this.croppedHeight = this.y_max - this.y_min + 1;
        this.croppedDepth = this.z_max - this.z_min + 1;
        if (this.sigmaValues.length > this.sigmasAcross * this.sigmasDown) {
            IJ.error((String)("A " + this.sigmasAcross + "x" + this.sigmasDown + " layout is not large enough for " + this.sigmaValues + " + 1 images"));
            return;
        }
        int paletteWidth = this.croppedWidth * this.sigmasAcross + (this.sigmasAcross + 1);
        int paletteHeight = this.croppedHeight * this.sigmasDown + (this.sigmasDown + 1);
        ImageStack newStack = new ImageStack(paletteWidth, paletteHeight);
        for (int z = 0; z < this.croppedDepth; ++z) {
            FloatProcessor fp = new FloatProcessor(paletteWidth, paletteHeight);
            newStack.addSlice("", (ImageProcessor)fp);
        }
        this.paletteImage = new ImagePlus("Pick Sigma and Maximum", newStack);
        this.setMax(this.defaultMax);
        PaletteCanvas paletteCanvas = new PaletteCanvas(this.paletteImage, this, this.croppedWidth, this.croppedHeight, this.sigmasAcross, this.sigmasDown);
        PaletteStackWindow paletteWindow = new PaletteStackWindow(this.paletteImage, paletteCanvas, this, this.defaultMax);
        this.paletteImage.setSlice(this.initial_z - this.z_min + 1);
        for (int sigmaIndex = 0; sigmaIndex < this.sigmaValues.length; ++sigmaIndex) {
            int sigmaY = sigmaIndex / this.sigmasAcross;
            int sigmaX = sigmaIndex % this.sigmasAcross;
            int offsetX = sigmaX * (this.croppedWidth + 1) + 1;
            int offsetY = sigmaY * (this.croppedHeight + 1) + 1;
            double sigma = this.sigmaValues[sigmaIndex];
            this.hep.setSigma(sigma);
            ImagePlus processed = this.hep.generateImage(cropped);
            if (!paletteWindow.manuallyChangedAlready) {
                float[] limits = Limits.getStackLimits(processed);
                int suggestedMax = (int)limits[1];
                paletteWindow.maxValueScrollbar.setValue(suggestedMax);
                paletteWindow.maxChanged(suggestedMax);
            }
            this.copyIntoPalette(processed, this.paletteImage, offsetX, offsetY);
            this.paletteImage.updateAndDraw();
        }
    }

    public static class PaletteCanvas
    extends ImageCanvas {
        SigmaPalette owner;
        int croppedWidth;
        int croppedHeight;
        int sigmasAcross;
        int sigmasDown;
        private int backBufferWidth;
        private int backBufferHeight;
        private Graphics backBufferGraphics;
        private Image backBufferImage;

        protected PaletteCanvas(ImagePlus imagePlus, SigmaPalette owner, int croppedWidth, int croppedHeight, int sigmasAcross, int sigmasDown) {
            super(imagePlus);
            this.owner = owner;
            this.croppedWidth = croppedWidth;
            this.croppedHeight = croppedHeight;
            this.sigmasAcross = sigmasAcross;
            this.sigmasDown = sigmasDown;
        }

        int sigmaIndexFromMouseEvent(MouseEvent e) {
            int sigmaX;
            int sx = e.getX();
            int sy = e.getY();
            int ox = this.offScreenX(sx);
            int oy = this.offScreenY(sy);
            int sigmaY = oy / (this.owner.croppedHeight + 1);
            int sigmaIndex = sigmaY * this.sigmasAcross + (sigmaX = ox / (this.owner.croppedWidth + 1));
            if (sigmaIndex >= 0 && sigmaIndex < this.owner.sigmaValues.length) {
                return sigmaIndex;
            }
            return -1;
        }

        public void mouseMoved(MouseEvent e) {
            int sigmaIndex = this.sigmaIndexFromMouseEvent(e);
            if (sigmaIndex >= 0) {
                double sigmaValue = this.owner.sigmaValues[sigmaIndex];
                IJ.showStatus((String)("\u03c3 = " + sigmaValue));
            } else {
                IJ.showStatus((String)"No  \u03c3 (unused entry)");
            }
        }

        public void mouseClicked(MouseEvent e) {
            int oldSelectedSigmaIndex = this.owner.getSelectedSigmaIndex();
            int sigmaIndex = this.sigmaIndexFromMouseEvent(e);
            if (sigmaIndex >= 0) {
                if (sigmaIndex == oldSelectedSigmaIndex) {
                    this.owner.setSelectedSigmaIndex(-1);
                } else {
                    this.owner.setSelectedSigmaIndex(sigmaIndex);
                }
            }
        }

        private void resetBackBuffer() {
            if (this.backBufferGraphics != null) {
                this.backBufferGraphics.dispose();
                this.backBufferGraphics = null;
            }
            if (this.backBufferImage != null) {
                this.backBufferImage.flush();
                this.backBufferImage = null;
            }
            this.backBufferWidth = this.getSize().width;
            this.backBufferHeight = this.getSize().height;
            this.backBufferImage = this.createImage(this.backBufferWidth, this.backBufferHeight);
            this.backBufferGraphics = this.backBufferImage.getGraphics();
        }

        public void paint(Graphics g) {
            if (this.backBufferWidth != this.getSize().width || this.backBufferHeight != this.getSize().height || this.backBufferImage == null || this.backBufferGraphics == null) {
                this.resetBackBuffer();
            }
            super.paint(this.backBufferGraphics);
            this.drawOverlay(this.backBufferGraphics);
            g.drawImage(this.backBufferImage, 0, 0, (ImageObserver)((Object)this));
        }

        protected void drawOverlay(Graphics g) {
            g.setColor(Color.MAGENTA);
            int width = this.imp.getWidth();
            int height = this.imp.getHeight();
            for (int i = 0; i <= this.sigmasAcross; ++i) {
                int x = i * (this.croppedWidth + 1);
                int screen_x = this.screenX(x);
                g.drawLine(screen_x, this.screenY(0), screen_x, this.screenY(height - 1));
            }
            for (int j = 0; j <= this.sigmasDown; ++j) {
                int y = j * (this.croppedHeight + 1);
                int screen_y = this.screenY(y);
                g.drawLine(this.screenX(0), screen_y, this.screenX(width - 1), screen_y);
            }
            int selectedSigmaIndex = this.owner.getSelectedSigmaIndex();
            if (selectedSigmaIndex >= 0 && selectedSigmaIndex < this.owner.sigmaValues.length) {
                g.setColor(Color.GREEN);
                int sigmaY = selectedSigmaIndex / this.sigmasAcross;
                int sigmaX = selectedSigmaIndex % this.sigmasAcross;
                int leftX = this.screenX(sigmaX * (this.croppedWidth + 1));
                int rightX = this.screenX((sigmaX + 1) * (this.croppedWidth + 1));
                int topY = this.screenY(sigmaY * (this.croppedHeight + 1));
                int bottomY = this.screenY((sigmaY + 1) * (this.croppedHeight + 1));
                g.drawLine(leftX, topY, rightX, topY);
                g.drawLine(leftX, topY, leftX, bottomY);
                g.drawLine(leftX, bottomY, rightX, bottomY);
                g.drawLine(rightX, bottomY, rightX, topY);
            }
        }
    }

    public static class PaletteStackWindow
    extends StackWindow {
        SigmaPalette owner;
        Label label;
        Scrollbar maxValueScrollbar;
        boolean manuallyChangedAlready = false;

        private void addExtraScrollbar(double defaultMaxValue) {
            this.label = new Label("");
            this.add(this.label);
            this.updateLabel(defaultMaxValue);
            this.maxValueScrollbar = new Scrollbar(0, (int)defaultMaxValue, 1, 1, 350);
            this.maxValueScrollbar.addAdjustmentListener(new AdjustmentListener(){

                @Override
                public void adjustmentValueChanged(AdjustmentEvent e) {
                    manuallyChangedAlready = true;
                    int newValue = e.getValue();
                    this.maxChanged(newValue);
                }
            });
            this.add(this.maxValueScrollbar);
            this.pack();
        }

        private void updateLabel(double maxValue) {
            int intMaxValue = (int)Math.round(maxValue);
            this.label.setText("Adjust maximum value: " + intMaxValue);
        }

        protected void maxChanged(double newValue) {
            this.updateLabel(newValue);
            if (this.owner != null) {
                this.owner.setMax(newValue);
            }
        }

        public void windowClosing(WindowEvent e) {
            if (this.owner != null && this.owner.listener != null) {
                this.owner.listener.sigmaPaletteClosing();
            }
            super.windowClosing(e);
        }

        public PaletteStackWindow(ImagePlus imp) {
            super(imp);
            this.addExtraScrollbar(80.0);
        }

        public PaletteStackWindow(ImagePlus imp, ImageCanvas ic, SigmaPalette owner, double defaultMax) {
            super(imp, ic);
            this.owner = owner;
            this.addExtraScrollbar(defaultMax);
        }
    }

    public static interface SigmaPaletteListener {
        public void newSigmaSelected(double var1);

        public void newMaximum(double var1);

        public void sigmaPaletteClosing();
    }
}

