/*
 * Decompiled with CFR 0.152.
 */
package leica;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.io.FileInfo;
import ij.io.FileOpener;
import ij.io.TiffDecoder;
import java.io.IOException;
import java.util.StringTokenizer;

public class LeicaSPReader
extends ImagePlus {
    protected ImagePlus[] images;
    protected int nr_frames = 1;
    protected int nr_channels = 1;
    protected String imageInfo;

    public int getNumberOfChannels() {
        return this.nr_channels;
    }

    public ImagePlus getImage(int i) {
        return this.images[i];
    }

    public FileInfo[] getFileInfo(String directory, String name) throws IOException {
        FileInfo[] info;
        LeicaTiffDecoder td = new LeicaTiffDecoder(directory, name);
        if (IJ.debugMode) {
            td.enableDebugging();
        }
        if ((info = td.getTiffInfo()) == null) {
            throw new IOException("This file does not appear to be in TIFF format.");
        }
        if (IJ.debugMode) {
            IJ.write((String)info[0].info);
        }
        return info;
    }

    ImageStack openStack(FileInfo[] fi, int channel) throws IOException {
        if (fi[0].fileType != 5) {
            throw new IOException("This does not appear to be  a stack of 8-bit color images.");
        }
        if (channel < 0 || channel >= this.nr_channels) {
            throw new IOException("Image does not contain channel " + channel);
        }
        int maxStacks = this.nr_channels;
        int width = fi[0].width;
        int height = fi[0].height;
        String name = fi[0].fileName;
        int length_per_channel = fi.length / this.nr_channels;
        ImageStack stack = new ImageStack(width, height);
        for (int i = 0; i < length_per_channel; ++i) {
            int k = i + channel * length_per_channel;
            if (fi[k].width != width || fi[k].height != height) break;
            FileOpener fo = new FileOpener(fi[k]);
            ImagePlus imp = fo.open(false);
            if (imp != null) {
                stack.addSlice("", imp.getProcessor());
            }
            IJ.showProgress((int)(i + 1), (int)length_per_channel);
        }
        return stack;
    }

    class LeicaTiffDecoder
    extends TiffDecoder {
        public LeicaTiffDecoder(String directory, String name) {
            super(directory, name);
        }

        public void saveImageDescription(byte[] description, FileInfo fi) {
            this.decodeImageDescription(description, fi);
        }

        public void decodeImageDescription(byte[] description, FileInfo fi) {
            LeicaSPReader.this.imageInfo = new String(description);
            if (new String(description, 0, 8).equals("[GLOBAL]")) {
                String file_specs;
                if (this.debugMode) {
                    IJ.write((String)"Leica file detected...\n");
                }
                fi.info = file_specs = new String(description);
                if (this.debugMode) {
                    IJ.write((String)file_specs);
                }
                StringTokenizer st = new StringTokenizer(file_specs, "\n= ");
                while (st.hasMoreTokens()) {
                    String s = st.nextToken();
                    if (s.equals("NumOfFrames")) {
                        LeicaSPReader.this.nr_frames = this.getInt(st);
                        if (!this.debugMode) continue;
                        IJ.write((String)(LeicaSPReader.this.nr_channels + " channels detected\n"));
                        continue;
                    }
                    if (s.equals("VoxelSizeX")) {
                        fi.pixelWidth = this.getDouble(st);
                        continue;
                    }
                    if (s.equals("VoxelSizeY")) {
                        fi.pixelHeight = this.getDouble(st);
                        continue;
                    }
                    if (!s.equals("VoxelSizeZ")) continue;
                    fi.pixelDepth = this.getDouble(st);
                }
            }
        }

        public int getInt(StringTokenizer st) {
            String temp = st.nextToken().trim();
            try {
                return Integer.parseInt(temp);
            }
            catch (NumberFormatException e) {
                throw new RuntimeException("invalid number: " + temp);
            }
        }

        public double getDouble(StringTokenizer st) {
            String temp = st.nextToken().trim();
            try {
                return Double.parseDouble(temp);
            }
            catch (NumberFormatException e) {
                throw new RuntimeException("invalid number: " + temp);
            }
        }
    }
}

