/*
 * Decompiled with CFR 0.152.
 */
package process3d;

import ij.IJ;
import ij.ImagePlus;
import ij.plugin.Duplicator;
import ij.process.ImageProcessor;
import java.util.Arrays;

public class MinMaxMedian {
    public static final int MINIMUM = 0;
    public static final int MAXIMUM = 1;
    public static final int MEDIAN = 2;
    private static final int diameter = 3;

    public static void main(String[] args) {
        ImagePlus imp = IJ.getImage();
        MinMaxMedian.convolve(imp, 2).show();
    }

    public static ImagePlus convolve(ImagePlus image, int method) {
        if (method < 0 || method >= 3) {
            IJ.error((String)"Neither MINIMUM nor MAXIMUM nor MEDIAN chosen");
            return null;
        }
        ImagePlus result = new Duplicator().run(image);
        int w = image.getWidth();
        int h = image.getHeight();
        int d = image.getStackSize();
        ImageProcessor[] in = new ImageProcessor[d];
        ImageProcessor[] out = new ImageProcessor[d];
        for (int z = 0; z < d; ++z) {
            in[z] = image.getStack().getProcessor(z + 1);
            out[z] = result.getStack().getProcessor(z + 1);
        }
        float[] values = new float[27];
        int r = 1;
        for (int z = 0; z < d; ++z) {
            IJ.showProgress((int)0, (int)d);
            for (int y = 0; y < h; ++y) {
                for (int x = 0; x < w; ++x) {
                    int idx = 0;
                    for (int k = z - r; k <= z + r; ++k) {
                        if (k < 0 || k >= d) continue;
                        for (int j = y - r; j <= y + r; ++j) {
                            if (j < 0 || j >= h) continue;
                            for (int i = x - r; i <= x + r; ++i) {
                                if (i < 0 || i >= w) continue;
                                values[idx++] = in[k].getf(i, j);
                            }
                        }
                    }
                    Arrays.sort(values, 0, idx);
                    float target = 0.0f;
                    switch (method) {
                        case 0: {
                            target = values[0];
                            break;
                        }
                        case 1: {
                            target = values[idx - 1];
                            break;
                        }
                        case 2: {
                            target = values[idx / 2];
                        }
                    }
                    out[z].setf(x, y, target);
                }
            }
        }
        String title = "";
        switch (method) {
            case 0: {
                title = "Minimum";
                break;
            }
            case 1: {
                title = "Maximum";
                break;
            }
            case 2: {
                title = "Median";
            }
        }
        result.setTitle(title + " of " + image.getTitle());
        return result;
    }
}

