/*
 * Decompiled with CFR 0.152.
 */
package vib.app.module;

import amira.AmiraParameters;
import ij.ImagePlus;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import vib.app.module.Module;
import vib.app.module.SplitChannels;
import vib.app.module.State;
import vib.segment.CustomStackWindow;

public class Label
extends Module {
    @Override
    public String getName() {
        return "Label";
    }

    @Override
    protected String getMessage() {
        return "Labelling";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void run(State state, int index) {
        new SplitChannels().runOnOneImage(state, index);
        this.prereqsDone(state, index);
        int refChannel = state.options.refChannel - 1;
        String imagePath = state.getImagePath(refChannel, index);
        String labelPath = state.getImagePath(-1, index);
        if (State.upToDate(imagePath, labelPath)) {
            return;
        }
        ImagePlus image = state.getImage(imagePath);
        Label.setGrayLUT(image);
        ImagePlus labels = state.getImage(labelPath);
        ActionListener a = new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void actionPerformed(ActionEvent e) {
                if (e.getActionCommand().equals("Ok")) {
                    1 var2_2 = this;
                    synchronized (var2_2) {
                        this.notifyAll();
                    }
                }
            }
        };
        CustomStackWindow csw = new CustomStackWindow(image);
        csw.setLabels(labels);
        if (labels == null) {
            labels = csw.getLabels();
            if (index >= 0) {
                ImagePlus templateLabels = state.getTemplateLabels();
                new AmiraParameters(templateLabels).setParameters(labels);
                csw.setLabels(labels);
            }
        }
        csw.addActionListener(a);
        ActionListener actionListener = a;
        synchronized (actionListener) {
            try {
                a.wait();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        image.close();
        csw.cleanUp();
        if (!state.save(labels, labelPath)) {
            throw new RuntimeException("Could not save " + labelPath);
        }
    }

    private static void setGrayLUT(ImagePlus ip) {
        byte[] channel = new byte[256];
        for (int i = 0; i < 256; ++i) {
            channel[i] = (byte)i;
        }
        IndexColorModel c = new IndexColorModel(8, 256, channel, channel, channel);
        ip.getProcessor().setColorModel((ColorModel)c);
        if (ip.getStackSize() > 1) {
            ip.getStack().setColorModel((ColorModel)c);
        }
    }
}

