/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.algorithm.morphology.table2d;

import net.imglib2.IterableInterval;
import net.imglib2.Localizable;
import net.imglib2.RandomAccess;
import net.imglib2.RandomAccessible;
import net.imglib2.RealCursor;
import net.imglib2.algorithm.neighborhood.Neighborhood;
import net.imglib2.algorithm.neighborhood.RectangleShape;
import net.imglib2.img.Img;
import net.imglib2.type.BooleanType;
import net.imglib2.view.ExtendedRandomAccessibleInterval;
import net.imglib2.view.Views;

public abstract class Abstract3x3TableOperation {
    private static final RectangleShape shape = new RectangleShape(1, false);

    protected abstract boolean[] getTable();

    protected abstract boolean getExtendedValue();

    protected <T extends BooleanType<T>> Img<T> calculate(Img<T> source) {
        Img<T> target = source.factory().create(source);
        BooleanType extendedVal = (BooleanType)((BooleanType)source.firstElement()).createVariable();
        extendedVal.set(this.getExtendedValue());
        ExtendedRandomAccessibleInterval<BooleanType, Img<T>> extended = Views.extendValue(source, extendedVal);
        this.calculate(extended, target);
        return target;
    }

    protected <T extends BooleanType<T>> void calculate(RandomAccessible<T> source, IterableInterval<T> target) {
        RandomAccessible accessible = shape.neighborhoodsRandomAccessible((RandomAccessible)source);
        RandomAccess randomAccess = accessible.randomAccess(target);
        RealCursor cursorTarget = target.cursor();
        boolean[] table = this.getTable();
        while (cursorTarget.hasNext()) {
            BooleanType targetVal = (BooleanType)cursorTarget.next();
            randomAccess.setPosition((Localizable)((Object)cursorTarget));
            Neighborhood neighborhood = (Neighborhood)randomAccess.get();
            RealCursor nc = neighborhood.cursor();
            int idx = 0;
            while (nc.hasNext()) {
                idx <<= 1;
                idx |= ((BooleanType)nc.next()).get() ? 1 : 0;
            }
            targetVal.set(table[idx]);
        }
    }
}

