/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.algorithm.region;

import net.imglib2.Cursor;
import net.imglib2.FinalInterval;
import net.imglib2.Localizable;
import net.imglib2.Point;
import net.imglib2.RandomAccess;
import net.imglib2.RandomAccessible;

public class CircleCursor<T>
implements Cursor<T> {
    private final RandomAccessible<T> rai;
    private final RandomAccess<T> ra;
    private final Localizable center;
    private final long radius;
    private final int dimX;
    private final int dimY;
    private long x;
    private long y;
    private long dx;
    private long dy;
    private long f;
    private Octant octant;
    private boolean hasNext;

    public CircleCursor(RandomAccessible<T> rai, Localizable center, long radius) {
        this(rai, center, radius, 0, 1);
    }

    public CircleCursor(RandomAccessible<T> rai, Localizable center, long radius, int dimX, int dimY) {
        int d;
        this.rai = rai;
        this.center = center;
        this.radius = radius;
        this.dimX = dimX;
        this.dimY = dimY;
        int numDimensions = rai.numDimensions();
        long[] minmax = new long[2 * numDimensions];
        for (d = 0; d < numDimensions; ++d) {
            minmax[d] = d == dimX || d == dimY ? center.getLongPosition(d) - radius : center.getLongPosition(d);
        }
        for (d = 0; d < numDimensions; ++d) {
            minmax[d + numDimensions] = d == dimX || d == dimY ? center.getLongPosition(d) + radius : center.getLongPosition(d);
        }
        FinalInterval interval = FinalInterval.createMinMax(minmax);
        this.ra = rai.randomAccess(interval);
        this.reset();
    }

    private CircleCursor(CircleCursor<T> c) {
        this.rai = c.rai;
        this.ra = c.ra.copy();
        this.center = new Point(c.center);
        this.radius = c.radius;
        this.dimX = c.dimX;
        this.dimY = c.dimY;
        this.x = c.x;
        this.y = c.y;
        this.dx = c.dx;
        this.dy = c.dy;
        this.f = c.f;
        this.octant = c.octant;
        this.hasNext = c.hasNext;
    }

    @Override
    public void reset() {
        this.x = 0L;
        this.y = this.radius;
        this.f = 1L - this.radius;
        this.dx = 1L;
        this.dy = -2L * this.radius;
        this.octant = Octant.INIT;
        this.ra.setPosition(this.center);
        this.hasNext = true;
    }

    @Override
    public void fwd() {
        switch (this.octant) {
            default: {
                this.ra.setPosition(this.center.getLongPosition(this.dimY) + this.radius, this.dimY);
                this.octant = Octant.NORTH;
                break;
            }
            case NORTH: {
                this.ra.setPosition(this.center.getLongPosition(this.dimY) - this.radius, this.dimY);
                this.octant = Octant.SOUTH;
                break;
            }
            case SOUTH: {
                this.ra.setPosition(this.center.getLongPosition(this.dimX) - this.radius, this.dimX);
                this.ra.setPosition(this.center.getLongPosition(this.dimY), this.dimY);
                this.octant = Octant.WEST;
                break;
            }
            case WEST: {
                this.ra.setPosition(this.center.getLongPosition(this.dimX) + this.radius, this.dimX);
                this.octant = Octant.EAST;
                break;
            }
            case EAST: {
                ++this.x;
                this.dx += 2L;
                this.f += this.dx;
                this.ra.setPosition(this.center.getLongPosition(this.dimX) + this.x, this.dimX);
                this.ra.setPosition(this.center.getLongPosition(this.dimY) + this.y, this.dimY);
                this.octant = Octant.O1;
                break;
            }
            case O1: {
                this.ra.setPosition(this.center.getLongPosition(this.dimX) - this.x, this.dimX);
                this.octant = Octant.O2;
                break;
            }
            case O2: {
                this.ra.setPosition(this.center.getLongPosition(this.dimY) - this.y, this.dimY);
                this.octant = Octant.O3;
                break;
            }
            case O3: {
                this.ra.setPosition(this.center.getLongPosition(this.dimX) + this.x, this.dimX);
                this.octant = Octant.O4;
                if (this.x < this.y) break;
                this.hasNext = false;
                break;
            }
            case O4: {
                this.ra.setPosition(this.center.getLongPosition(this.dimX) + this.y, this.dimX);
                this.ra.setPosition(this.center.getLongPosition(this.dimY) - this.x, this.dimY);
                this.octant = Octant.O5;
                break;
            }
            case O5: {
                this.ra.setPosition(this.center.getLongPosition(this.dimX) - this.y, this.dimX);
                this.octant = Octant.O6;
                break;
            }
            case O6: {
                this.ra.setPosition(this.center.getLongPosition(this.dimY) + this.x, this.dimY);
                this.octant = Octant.O7;
                break;
            }
            case O7: {
                this.ra.setPosition(this.center.getLongPosition(this.dimX) + this.y, this.dimX);
                this.octant = Octant.O8;
                if (this.x < this.y - 1L) break;
                this.hasNext = false;
                break;
            }
            case O8: {
                if (this.f > 0L) {
                    --this.y;
                    this.dy += 2L;
                    this.f += this.dy;
                }
                ++this.x;
                this.dx += 2L;
                this.f += this.dx;
                this.ra.setPosition(this.center.getLongPosition(this.dimX) + this.x, this.dimX);
                this.ra.setPosition(this.center.getLongPosition(this.dimY) + this.y, this.dimY);
                this.octant = Octant.O1;
            }
        }
    }

    @Override
    public boolean hasNext() {
        return this.hasNext;
    }

    @Override
    public void localize(float[] position) {
        this.ra.localize(position);
    }

    @Override
    public void localize(double[] position) {
        this.ra.localize(position);
    }

    @Override
    public float getFloatPosition(int d) {
        return this.ra.getFloatPosition(d);
    }

    @Override
    public double getDoublePosition(int d) {
        return this.ra.getDoublePosition(d);
    }

    @Override
    public int numDimensions() {
        return this.ra.numDimensions();
    }

    @Override
    public T get() {
        return this.ra.get();
    }

    @Override
    public T getType() {
        return this.ra.getType();
    }

    @Override
    public void jumpFwd(long steps) {
        int i = 0;
        while ((long)i < steps) {
            this.fwd();
            ++i;
        }
    }

    @Override
    public T next() {
        this.fwd();
        return this.get();
    }

    @Override
    public void localize(int[] position) {
        this.ra.localize(position);
    }

    @Override
    public void localize(long[] position) {
        this.ra.localize(position);
    }

    @Override
    public int getIntPosition(int d) {
        return this.ra.getIntPosition(d);
    }

    @Override
    public long getLongPosition(int d) {
        return this.ra.getLongPosition(d);
    }

    @Override
    public Cursor<T> copy() {
        return new CircleCursor<T>(this);
    }

    private static enum Octant {
        INIT,
        EAST,
        NORTH,
        WEST,
        SOUTH,
        O1,
        O2,
        O3,
        O4,
        O5,
        O6,
        O7,
        O8;

    }
}

