/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.models;

import ij.IJ;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import mpicbg.models.ErrorStatistic;
import mpicbg.models.IllDefinedDataPointsException;
import mpicbg.models.NotEnoughDataPointsException;
import mpicbg.models.Tile;
import mpicbg.models.TileConfiguration;

public class TileUtil {
    public static final Iterable<Tile<?>[]> generateIndependentGroups(final Set<Tile<?>> tiles, final int maxArrayElements) {
        return new Iterable<Tile<?>[]>(){

            @Override
            public final Iterator<Tile<?>[]> iterator() {
                return new Iterator<Tile<?>[]>(){
                    final HashSet<Tile<?>> remaining;
                    {
                        this.remaining = new HashSet(this.shuffle(tiles));
                    }

                    private final Collection<Tile<?>> shuffle(Collection<Tile<?>> ts) {
                        ArrayList s = new ArrayList(ts);
                        Collections.shuffle(s);
                        return s;
                    }

                    @Override
                    public final boolean hasNext() {
                        return this.remaining.size() > 0;
                    }

                    @Override
                    public Tile<?>[] next() {
                        Tile[] array = new Tile[maxArrayElements];
                        Iterator<Tile<?>> it = this.remaining.iterator();
                        array[0] = it.next();
                        it.remove();
                        int next = 1;
                        block0: while (next < maxArrayElements && it.hasNext()) {
                            Tile<?> t = it.next();
                            for (int i = 0; i < next; ++i) {
                                if (array[i].getConnectedTiles().contains(t)) continue;
                                array[next] = t;
                                ++next;
                                it.remove();
                                continue block0;
                            }
                        }
                        if (maxArrayElements != next) {
                            Tile[] a = new Tile[next];
                            System.arraycopy(array, 0, a, 0, next);
                            return a;
                        }
                        return array;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    public static void optimizeConcurrently(ErrorStatistic observer, double maxAllowedError, int maxIterations, int maxPlateauwidth, double damp, TileConfiguration tc, Set<Tile<?>> tiles, Set<Tile<?>> fixedTiles, int nThreads) {
        TileUtil.optimizeConcurrently(observer, maxAllowedError, maxIterations, maxPlateauwidth, damp, tc, tiles, fixedTiles, nThreads, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void optimizeConcurrently(ErrorStatistic observer, double maxAllowedError, int maxIterations, int maxPlateauwidth, double damp, TileConfiguration tc, Set<Tile<?>> tiles, Set<Tile<?>> fixedTiles, int nThreads, boolean verbose) {
        ThreadPoolExecutor executor = (ThreadPoolExecutor)Executors.newFixedThreadPool(nThreads);
        try {
            long t0 = System.currentTimeMillis();
            ArrayList freeTiles = new ArrayList(tiles.size() - fixedTiles.size());
            for (Tile<?> t : tiles) {
                if (fixedTiles.contains(t)) continue;
                freeTiles.add(t);
            }
            Collections.shuffle(freeTiles);
            long t1 = System.currentTimeMillis();
            System.out.println("Shuffling took " + (t1 - t0) + " ms");
            tc.apply(executor);
            long t2 = System.currentTimeMillis();
            System.out.println("First apply took " + (t2 - t1) + " ms");
            int i = 0;
            ConcurrentHashMap.KeySetView executingTiles = ConcurrentHashMap.newKeySet();
            for (boolean proceed = i < maxIterations ? true : false; proceed; proceed &= ++i < maxIterations) {
                Collections.shuffle(freeTiles);
                ConcurrentLinkedDeque pending = new ConcurrentLinkedDeque(freeTiles);
                ArrayList<Future<Void>> tasks = new ArrayList<Future<Void>>(nThreads);
                for (int j = 0; j < nThreads; ++j) {
                    boolean bl = j == 0;
                    tasks.add(executor.submit(() -> TileUtil.fitAndApplyWorker(pending, executingTiles, damp, cleanUp)));
                }
                for (Future future : tasks) {
                    try {
                        future.get();
                    }
                    catch (InterruptedException | ExecutionException e) {
                        throw new RuntimeException(e);
                    }
                }
                tc.updateErrors(executor);
                observer.add(tc.getError());
                if (verbose) {
                    IJ.log((String)(i + ": " + tc.getError() + " " + observer.max));
                }
                if (i <= maxPlateauwidth) continue;
                proceed = tc.getError() > maxAllowedError;
                for (int d = maxPlateauwidth; !proceed && d >= 1; d /= 2) {
                    try {
                        proceed = Math.abs(observer.getWideSlope(d)) > 1.0E-4;
                        continue;
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            }
            long t3 = System.currentTimeMillis();
            System.out.println("Concurrent tile optimization loop took " + (t3 - t2) + " ms, total took " + (t3 - t0) + " ms");
        }
        finally {
            executor.shutdownNow();
        }
    }

    private static Void fitAndApplyWorker(Deque<Tile<?>> pendingTiles, Set<Tile<?>> executingTiles, double damp, boolean cleanUp) throws NotEnoughDataPointsException, IllDefinedDataPointsException {
        int n = pendingTiles.size();
        for (int i = 0; i < n || cleanUp; ++i) {
            Tile<?> tile = pendingTiles.pollFirst();
            if (tile == null) {
                return null;
            }
            executingTiles.add(tile);
            boolean canBeProcessed = Collections.disjoint(tile.getConnectedTiles(), executingTiles);
            if (canBeProcessed) {
                tile.fitModel();
                tile.apply(damp);
                executingTiles.remove(tile);
                continue;
            }
            executingTiles.remove(tile);
            pendingTiles.addLast(tile);
        }
        return null;
    }
}

