/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.log;

import org.scijava.log.LogService;

public class DefaultUncaughtExceptionHandler
implements Thread.UncaughtExceptionHandler {
    private final LogService log;

    public DefaultUncaughtExceptionHandler(LogService log) {
        this.log = log;
    }

    @Override
    public void uncaughtException(Thread thread, Throwable throwable) {
        this.log.error("Uncaught exception in thread " + thread, throwable);
    }

    public void handle(Exception exception) {
        this.log.error("Uncaught exception on the Event Dispatch Thread", exception);
    }

    public static void install(LogService log) {
        DefaultUncaughtExceptionHandler handler = new DefaultUncaughtExceptionHandler(log);
        Thread.setDefaultUncaughtExceptionHandler(handler);
    }
}

