/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ui.dnd;

import org.scijava.app.StatusService;
import org.scijava.event.EventHandler;
import org.scijava.plugin.AbstractHandlerService;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import org.scijava.service.Service;
import org.scijava.ui.dnd.DragAndDropHandler;
import org.scijava.ui.dnd.DragAndDropService;
import org.scijava.ui.dnd.event.DragEnterEvent;
import org.scijava.ui.dnd.event.DragExitEvent;
import org.scijava.ui.dnd.event.DragOverEvent;
import org.scijava.ui.dnd.event.DropEvent;

@Plugin(type=Service.class)
public class DefaultDragAndDropService
extends AbstractHandlerService<Object, DragAndDropHandler<Object>>
implements DragAndDropService {
    private static final String SUPPORTED = "Drag and Drop";
    private static final String UNSUPPORTED = "Unsupported Object";
    @Parameter
    private StatusService statusService;

    @EventHandler
    protected void onEvent(DragEnterEvent e) {
        boolean compatible = this.supports(e.getData(), e.getDisplay());
        String message = compatible ? SUPPORTED : UNSUPPORTED;
        this.statusService.showStatus("< <" + message + "> >");
        if (compatible) {
            e.setAccepted(true);
        }
    }

    @EventHandler
    protected void onEvent(DragExitEvent e) {
        this.statusService.clearStatus();
    }

    @EventHandler
    protected void onEvent(DragOverEvent e) {
    }

    @EventHandler
    protected void onEvent(DropEvent e) {
        if (!this.supports(e.getData(), e.getDisplay())) {
            return;
        }
        boolean success = this.drop(e.getData(), e.getDisplay());
        e.setSuccessful(success);
    }
}

