/*
 * Decompiled with CFR 0.152.
 */
package bdv.export;

import bdv.export.ExportMipmapInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import mpicbg.spim.data.generic.sequence.AbstractSequenceDescription;
import mpicbg.spim.data.generic.sequence.BasicViewSetup;
import mpicbg.spim.data.sequence.VoxelDimensions;

public class ProposeMipmaps {
    public static Map<Integer, ExportMipmapInfo> proposeMipmaps(AbstractSequenceDescription<?, ?, ?> seq) {
        HashMap<Integer, ExportMipmapInfo> perSetupExportMipmapInfo = new HashMap<Integer, ExportMipmapInfo>();
        for (BasicViewSetup setup : seq.getViewSetupsOrdered()) {
            perSetupExportMipmapInfo.put(setup.getId(), ProposeMipmaps.proposeMipmaps(setup));
        }
        return perSetupExportMipmapInfo;
    }

    public static ExportMipmapInfo proposeMipmaps(BasicViewSetup setup) {
        return ProposeMipmaps.proposeMipmaps(setup, 4096);
    }

    public static ExportMipmapInfo proposeMipmaps(BasicViewSetup setup, int maxNumElements) {
        VoxelDimensions voxelSize = setup.getVoxelSize();
        double[] voxelScale = new double[3];
        voxelSize.dimensions(voxelScale);
        ProposeMipmaps.normalizeVoxelSize(voxelScale);
        int[] res = new int[]{1, 1, 1};
        long[] size = new long[3];
        ArrayList<Object> resolutions = new ArrayList<Object>();
        ArrayList<int[]> subdivisions = new ArrayList<int[]>();
        while (true) {
            int d;
            resolutions.add(res.clone());
            setup.getSize().dimensions(size);
            long maxSize = 0L;
            for (int d2 = 0; d2 < 3; ++d2) {
                size[d2] = Math.max(1L, size[d2] / (long)res[d2]);
                maxSize = Math.max(maxSize, size[d2]);
            }
            subdivisions.add(ProposeMipmaps.suggestPoTBlockSize(voxelScale, size, maxNumElements));
            if (maxSize <= 256L) break;
            boolean anyDimensionChanged = false;
            for (d = 0; d < 3; ++d) {
                if (!(voxelScale[d] <= 2.0) || size[d] <= 1L) continue;
                int n = d;
                res[n] = res[n] * 2;
                int n2 = d;
                voxelScale[n2] = voxelScale[n2] * 2.0;
                anyDimensionChanged = true;
            }
            if (!anyDimensionChanged) {
                d = 0;
                while (d < 3) {
                    int n = d++;
                    res[n] = res[n] * 2;
                }
            }
            ProposeMipmaps.normalizeVoxelSize(voxelScale);
        }
        return new ExportMipmapInfo((int[][])resolutions.toArray((T[])new int[0][0]), (int[][])subdivisions.toArray((T[])new int[0][0]));
    }

    public static String getArrayString(int[][] resolutions) {
        StringBuilder sb = new StringBuilder();
        sb.append("{ ");
        boolean first = true;
        for (int[] res : resolutions) {
            if (first) {
                first = false;
            } else {
                sb.append(", ");
            }
            sb.append(String.format("{%d,%d,%d}", res[0], res[1], res[2]));
        }
        sb.append(" }");
        return sb.toString();
    }

    public static void normalizeVoxelSize(double[] size) {
        int d;
        double minVoxelDim = Double.POSITIVE_INFINITY;
        for (d = 0; d < 3; ++d) {
            minVoxelDim = Math.min(minVoxelDim, size[d]);
        }
        d = 0;
        while (d < 3) {
            int n = d++;
            size[n] = size[n] / minVoxelDim;
        }
    }

    public static int[] suggestPoTBlockSize(double[] voxelSize, int maxNumElements) {
        return ProposeMipmaps.suggestPoTBlockSize(voxelSize, null, maxNumElements);
    }

    public static int[] suggestPoTBlockSize(double[] voxelSize, long[] size, int maxNumElements) {
        int n = voxelSize.length;
        double[] bias = new double[n];
        Arrays.setAll(bias, d -> 0.01 * (double)(n - d));
        return ProposeMipmaps.suggestPoTBlockSize(voxelSize, size, maxNumElements, bias);
    }

    private static int[] suggestPoTBlockSize(double[] voxelSize, long[] size, int maxNumElements, double[] bias) {
        int n = voxelSize.length;
        double[] shape = new double[n];
        double shapeVol = 1.0;
        for (int d2 = 0; d2 < n; ++d2) {
            shape[d2] = 1.0 / voxelSize[d2];
            shapeVol *= shape[d2];
        }
        double m = Math.pow((double)maxNumElements / shapeVol, 1.0 / (double)n);
        double sumNumBits = Math.log(maxNumElements) / Math.log(2.0);
        double[] numBits = new double[n];
        Arrays.setAll(numBits, d -> Math.log(m * shape[d]) / Math.log(2.0));
        int[] intNumBits = new int[n];
        Arrays.setAll(intNumBits, d -> Math.max(0, (int)numBits[d]));
        int[] fullSizeBits = new int[n];
        if (size != null) {
            Arrays.setAll(fullSizeBits, d -> Math.max(0, (int)(Math.log(size[d] - 1L) / Math.log(2.0)) + 1));
            Arrays.setAll(intNumBits, d -> Math.min(intNumBits[d], fullSizeBits[d]));
        }
        int sumIntNumBits = Arrays.stream(intNumBits).sum();
        while ((double)(sumIntNumBits + 1) <= sumNumBits) {
            double maxDiff = Double.NEGATIVE_INFINITY;
            int maxDiffDim = 0;
            for (int d3 = 0; d3 < n; ++d3) {
                double diff;
                if (size != null && intNumBits[d3] >= fullSizeBits[d3] || !((diff = numBits[d3] - (double)intNumBits[d3] + bias[d3]) > maxDiff)) continue;
                maxDiff = diff;
                maxDiffDim = d3;
            }
            int n2 = maxDiffDim;
            intNumBits[n2] = intNumBits[n2] + 1;
            ++sumIntNumBits;
        }
        int[] blockSize = new int[n];
        for (int d4 = 0; d4 < n; ++d4) {
            blockSize[d4] = 1 << intNumBits[d4];
        }
        return blockSize;
    }
}

