/*
 * Decompiled with CFR 0.152.
 */
package bdv.img.imaris;

import bdv.img.imaris.HDF5AccessHack;
import bdv.img.imaris.ImarisImageLoader;
import bdv.spimdata.SequenceDescriptionMinimal;
import bdv.spimdata.SpimDataMinimal;
import ch.systemsx.cisd.hdf5.HDF5DataSetInformation;
import ch.systemsx.cisd.hdf5.HDF5Factory;
import ch.systemsx.cisd.hdf5.IHDF5Reader;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import mpicbg.spim.data.generic.sequence.BasicImgLoader;
import mpicbg.spim.data.generic.sequence.BasicViewSetup;
import mpicbg.spim.data.registration.ViewRegistration;
import mpicbg.spim.data.registration.ViewRegistrations;
import mpicbg.spim.data.sequence.FinalVoxelDimensions;
import mpicbg.spim.data.sequence.TimePoint;
import mpicbg.spim.data.sequence.TimePoints;
import mpicbg.spim.data.sequence.ViewId;
import mpicbg.spim.data.sequence.VoxelDimensions;
import net.imglib2.Dimensions;
import net.imglib2.FinalDimensions;
import net.imglib2.realtransform.AffineTransform3D;

public class Imaris {
    public static SpimDataMinimal openIms(String fn) throws IOException {
        HDF5AccessHack access;
        IHDF5Reader reader = HDF5Factory.openForReading((String)fn);
        try {
            access = new HDF5AccessHack(reader);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        HashMap<Integer, TimePoint> timepointMap = new HashMap<Integer, TimePoint>();
        HashMap<Integer, BasicViewSetup> setupMap = new HashMap<Integer, BasicViewSetup>();
        String path = "DataSetInfo/Image";
        double[] extMax = new double[]{Double.parseDouble(access.readImarisAttributeString(path, "ExtMax0")), Double.parseDouble(access.readImarisAttributeString(path, "ExtMax1")), Double.parseDouble(access.readImarisAttributeString(path, "ExtMax2"))};
        double[] extMin = new double[]{Double.parseDouble(access.readImarisAttributeString(path, "ExtMin0")), Double.parseDouble(access.readImarisAttributeString(path, "ExtMin1")), Double.parseDouble(access.readImarisAttributeString(path, "ExtMin2"))};
        int[] imageSize = new int[]{Integer.parseInt(access.readImarisAttributeString(path, "X")), Integer.parseInt(access.readImarisAttributeString(path, "Y")), Integer.parseInt(access.readImarisAttributeString(path, "Z"))};
        String unit = access.readImarisAttributeString(path, "Unit", "um");
        FinalVoxelDimensions voxelSize = new FinalVoxelDimensions(unit, new double[]{(extMax[0] - extMin[0]) / (double)imageSize[0], (extMax[1] - extMin[1]) / (double)imageSize[1], (extMax[2] - extMin[2]) / (double)imageSize[2]});
        List resolutionNames = reader.getGroupMembers("DataSet");
        for (String resolutionName : resolutionNames) {
            if (!resolutionName.startsWith("ResolutionLevel ")) {
                throw new IOException("unexpected content '" + resolutionName + "' while reading " + fn);
            }
            int level = Integer.parseInt(resolutionName.substring("ResolutionLevel ".length()));
            List timepointNames = reader.getGroupMembers("DataSet/" + resolutionName);
            for (String timepointName : timepointNames) {
                if (!timepointName.startsWith("TimePoint ")) {
                    throw new IOException("unexpected content '" + timepointName + "' while reading " + fn);
                }
                int timepoint = Integer.parseInt(timepointName.substring("TimePoint ".length()));
                if (!timepointMap.containsKey(timepoint)) {
                    timepointMap.put(timepoint, new TimePoint(timepoint));
                }
                List channelNames = reader.getGroupMembers("DataSet/" + resolutionName + "/" + timepointName);
                for (String channelName : channelNames) {
                    if (!channelName.startsWith("Channel ")) {
                        throw new IOException("unexpected content '" + channelName + "' while reading " + fn);
                    }
                    HDF5DataSetInformation info = reader.getDataSetInformation("DataSet/" + resolutionName + "/" + timepointName + "/" + channelName + "/Data");
                    int channel = Integer.parseInt(channelName.substring("Channel ".length()));
                    if (setupMap.containsKey(channel)) continue;
                    String defaultSetupName = "channel " + channel;
                    String name = access.readImarisAttributeString("DataSetInfo/Channel " + channel, "Name", defaultSetupName);
                    BasicViewSetup setup = new BasicViewSetup(channel, name, (Dimensions)new FinalDimensions(imageSize), (VoxelDimensions)voxelSize);
                    setupMap.put(channel, setup);
                }
            }
        }
        SequenceDescriptionMinimal seq = new SequenceDescriptionMinimal(new TimePoints(timepointMap), setupMap, null, null);
        ImarisImageLoader imgLoader = new ImarisImageLoader(new File(fn), seq);
        seq.setImgLoader((BasicImgLoader)imgLoader);
        File basePath = new File(fn).getParentFile();
        HashMap<ViewId, ViewRegistration> registrations = new HashMap<ViewId, ViewRegistration>();
        for (BasicViewSetup setup : seq.getViewSetupsOrdered()) {
            int setupId = setup.getId();
            AffineTransform3D calib = new AffineTransform3D();
            double sx = voxelSize.dimension(0);
            double sy = voxelSize.dimension(1);
            double sz = voxelSize.dimension(2);
            calib.set(sx, 0.0, 0.0, 0.0, 0.0, sy, 0.0, 0.0, 0.0, 0.0, sz, 0.0);
            for (TimePoint timepoint : seq.getTimePoints().getTimePointsOrdered()) {
                int timepointId = timepoint.getId();
                registrations.put(new ViewId(timepointId, setupId), new ViewRegistration(timepointId, setupId, calib));
            }
        }
        SpimDataMinimal spimData = new SpimDataMinimal(basePath, seq, new ViewRegistrations(registrations));
        reader.close();
        return spimData;
    }
}

