/*
 * Decompiled with CFR 0.152.
 */
package bdv.tools;

import bdv.tools.CloseWindowActions;
import bdv.ui.keymap.Keymap;
import bdv.ui.settings.SettingsPage;
import bdv.ui.settings.SettingsPanel;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JDialog;
import org.scijava.ui.behaviour.KeyStrokeAdder;
import org.scijava.ui.behaviour.util.Actions;

public class PreferencesDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    private final SettingsPanel settingsPanel = new SettingsPanel();

    public PreferencesDialog(Frame owner, Keymap keymap, String[] keyConfigContexts) {
        super(owner, "Preferences", false);
        this.settingsPanel.onOk(() -> this.setVisible(false));
        this.settingsPanel.onCancel(() -> this.setVisible(false));
        this.setDefaultCloseOperation(1);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                PreferencesDialog.this.settingsPanel.cancel();
            }
        });
        ActionMap am = this.getRootPane().getActionMap();
        InputMap im = this.getRootPane().getInputMap(1);
        Actions actions = new Actions(im, am, (KeyStrokeAdder.Factory)keymap.getConfig(), keyConfigContexts);
        CloseWindowActions.install(actions, this);
        keymap.updateListeners().add(() -> actions.updateKeyConfig(keymap.getConfig()));
        this.getContentPane().add((Component)this.settingsPanel, "Center");
        this.pack();
    }

    public void addPage(SettingsPage page) {
        this.settingsPanel.addPage(page);
        this.pack();
    }

    public void removePage(String path) {
        this.settingsPanel.removePage(path);
        this.pack();
    }
}

