/*
 * Decompiled with CFR 0.152.
 */
package bdv.ui.settings;

import bdv.ui.settings.SettingsPage;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.util.ArrayList;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import javax.swing.border.MatteBorder;

public class SingleSettingsPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private final SettingsPage page;
    private final ArrayList<Runnable> runOnOk;
    private final ArrayList<Runnable> runOnCancel;

    public SingleSettingsPanel(SettingsPage page) {
        this.page = page;
        JButton cancel = new JButton("Cancel");
        JButton apply = new JButton("Apply");
        JButton ok = new JButton("OK");
        JPanel buttons = new JPanel();
        buttons.setLayout(new BoxLayout(buttons, 2));
        buttons.add(Box.createHorizontalGlue());
        buttons.add(cancel);
        buttons.add(apply);
        buttons.add(ok);
        JPanel content = new JPanel(new BorderLayout());
        content.add((Component)page.getJPanel(), "Center");
        content.setBorder(new MatteBorder(0, 0, 1, 0, Color.LIGHT_GRAY));
        this.setLayout(new BorderLayout());
        this.add((Component)content, "Center");
        buttons.setBorder(new EmptyBorder(10, 0, 5, 10));
        this.add((Component)buttons, "South");
        this.runOnCancel = new ArrayList();
        this.runOnOk = new ArrayList();
        cancel.addActionListener(e -> this.cancel());
        ok.addActionListener(e -> {
            page.apply();
            this.runOnOk.forEach(Runnable::run);
        });
        apply.setEnabled(false);
        page.modificationListeners().add(() -> apply.setEnabled(true));
        apply.addActionListener(e -> {
            apply.setEnabled(false);
            page.apply();
        });
    }

    public void cancel() {
        this.page.cancel();
        this.runOnCancel.forEach(Runnable::run);
    }

    public synchronized void onOk(Runnable runnable) {
        this.runOnOk.add(runnable);
    }

    public synchronized void onCancel(Runnable runnable) {
        this.runOnCancel.add(runnable);
    }
}

