/*
 * Decompiled with CFR 0.152.
 */
package bdv.util;

import bdv.util.BoundedValueDouble;

public class BoundedIntervalDouble {
    private final BoundedValueDouble minValue;
    private final BoundedValueDouble maxValue;
    protected final double minIntervalSize;

    public BoundedIntervalDouble(double rangeMin, double rangeMax, double initialMin, double initialMax, final double minIntervalSize) {
        this.minIntervalSize = minIntervalSize;
        this.minValue = new BoundedValueDouble(rangeMin, rangeMax - minIntervalSize, initialMin){

            @Override
            public void setCurrentValue(double value) {
                super.setCurrentValue(value);
                double min = BoundedIntervalDouble.this.minValue.getCurrentValue();
                double max = BoundedIntervalDouble.this.maxValue.getCurrentValue();
                if (min > max - minIntervalSize) {
                    max = min + minIntervalSize;
                    BoundedIntervalDouble.this.maxValue.setCurrentValue(max);
                }
                BoundedIntervalDouble.this.updateInterval(min, max);
            }
        };
        this.maxValue = new BoundedValueDouble(rangeMin + minIntervalSize, rangeMax, initialMax){

            @Override
            public void setCurrentValue(double value) {
                super.setCurrentValue(value);
                double min = BoundedIntervalDouble.this.minValue.getCurrentValue();
                double max = BoundedIntervalDouble.this.maxValue.getCurrentValue();
                if (min > max - minIntervalSize) {
                    min = max - minIntervalSize;
                    BoundedIntervalDouble.this.minValue.setCurrentValue(min);
                }
                BoundedIntervalDouble.this.updateInterval(min, max);
            }
        };
    }

    protected void updateInterval(double min, double max) {
    }

    public BoundedValueDouble getMinBoundedValue() {
        return this.minValue;
    }

    public BoundedValueDouble getMaxBoundedValue() {
        return this.maxValue;
    }

    public double getRangeMin() {
        return this.minValue.getRangeMin();
    }

    public double getRangeMax() {
        return this.maxValue.getRangeMax();
    }

    public void setRange(double min, double max) {
        assert (min < max - this.minIntervalSize);
        this.minValue.setRange(min, max - this.minIntervalSize);
        this.maxValue.setRange(min + this.minIntervalSize, max);
        double currentMin = this.minValue.getCurrentValue();
        double currentMax = this.maxValue.getCurrentValue();
        if (currentMin > currentMax - this.minIntervalSize) {
            if (currentMax == max) {
                this.minValue.setCurrentValue(currentMax - this.minIntervalSize);
            } else {
                this.maxValue.setCurrentValue(currentMin + this.minIntervalSize);
            }
        }
    }
}

