/*
 * Decompiled with CFR 0.152.
 */
package bdv.viewer;

import bdv.TransformEventHandler;
import bdv.viewer.InteractiveDisplay;
import bdv.viewer.OverlayRenderer;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelListener;
import javax.swing.JComponent;
import org.scijava.listeners.Listeners;

public class InteractiveDisplayCanvas
extends JComponent
implements InteractiveDisplay {
    private TransformEventHandler handler;
    private final Listeners.List<OverlayRenderer> overlayRenderers;

    public InteractiveDisplayCanvas(int width, int height) {
        this.setPreferredSize(new Dimension(width, height));
        this.setFocusable(true);
        this.overlayRenderers = new Listeners.SynchronizedList(r -> r.setCanvasSize(this.getWidth(), this.getHeight()));
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                int w = InteractiveDisplayCanvas.this.getWidth();
                int h = InteractiveDisplayCanvas.this.getHeight();
                ((InteractiveDisplayCanvas)InteractiveDisplayCanvas.this).overlayRenderers.list.forEach(r -> r.setCanvasSize(w, h));
                if (InteractiveDisplayCanvas.this.handler != null) {
                    InteractiveDisplayCanvas.this.handler.setCanvasSize(w, h, true);
                }
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                InteractiveDisplayCanvas.this.requestFocusInWindow();
            }
        });
    }

    @Override
    public Listeners<OverlayRenderer> overlays() {
        return this.overlayRenderers;
    }

    @Override
    public void addHandler(Object h) {
        if (h instanceof KeyListener) {
            this.addKeyListener((KeyListener)h);
        }
        if (h instanceof MouseMotionListener) {
            this.addMouseMotionListener((MouseMotionListener)h);
        }
        if (h instanceof MouseListener) {
            this.addMouseListener((MouseListener)h);
        }
        if (h instanceof MouseWheelListener) {
            this.addMouseWheelListener((MouseWheelListener)h);
        }
        if (h instanceof FocusListener) {
            this.addFocusListener((FocusListener)h);
        }
    }

    @Override
    public void removeHandler(Object h) {
        if (h instanceof KeyListener) {
            this.removeKeyListener((KeyListener)h);
        }
        if (h instanceof MouseMotionListener) {
            this.removeMouseMotionListener((MouseMotionListener)h);
        }
        if (h instanceof MouseListener) {
            this.removeMouseListener((MouseListener)h);
        }
        if (h instanceof MouseWheelListener) {
            this.removeMouseWheelListener((MouseWheelListener)h);
        }
        if (h instanceof FocusListener) {
            this.removeFocusListener((FocusListener)h);
        }
    }

    public void setTransformEventHandler(TransformEventHandler transformEventHandler) {
        if (this.handler != null) {
            this.removeHandler(this.handler);
        }
        this.handler = transformEventHandler;
        int w = this.getWidth();
        int h = this.getHeight();
        if (w <= 0 || h <= 0) {
            Dimension preferred = this.getPreferredSize();
            w = preferred.width;
            h = preferred.height;
        }
        this.handler.setCanvasSize(w, h, false);
        this.addHandler(this.handler);
    }

    @Override
    public void paintComponent(Graphics g) {
        this.overlayRenderers.list.forEach(r -> r.drawOverlays(g));
    }

    @Deprecated
    public void addOverlayRenderer(OverlayRenderer renderer) {
        this.overlayRenderers.add((Object)renderer);
    }

    @Deprecated
    public void removeOverlayRenderer(OverlayRenderer renderer) {
        this.overlayRenderers.remove((Object)renderer);
    }
}

