/*
 * Decompiled with CFR 0.152.
 */
package bdv.viewer.animate;

import bdv.util.Affine3DHelpers;
import bdv.viewer.animate.AbstractTransformAnimator;
import net.imglib2.realtransform.AffineTransform3D;
import net.imglib2.util.LinAlgHelpers;

public class SimilarityTransformAnimator
extends AbstractTransformAnimator {
    private final double[] qStart;
    private final double[] qDiff;
    private final double[] xg0Start;
    private final double[] xg0Diff;
    private final double scaleStart;
    private final double scaleEnd;
    private final double scaleDiff;
    private final double scaleRate;
    private final double cX;
    private final double cY;

    public SimilarityTransformAnimator(AffineTransform3D transformStart, AffineTransform3D transformEnd, double cX, double cY, long duration) {
        super(duration);
        this.cX = cX;
        this.cY = cY;
        this.qStart = new double[4];
        double[] qStartInv = new double[4];
        double[] qEnd = new double[4];
        double[] qEndInv = new double[4];
        this.qDiff = new double[4];
        Affine3DHelpers.extractRotation(transformStart, this.qStart);
        LinAlgHelpers.quaternionInvert(this.qStart, qStartInv);
        Affine3DHelpers.extractRotation(transformEnd, qEnd);
        LinAlgHelpers.quaternionInvert(qEnd, qEndInv);
        LinAlgHelpers.quaternionMultiply(qStartInv, qEnd, this.qDiff);
        if (this.qDiff[0] < 0.0) {
            LinAlgHelpers.scale(this.qDiff, -1.0, this.qDiff);
        }
        this.scaleStart = Affine3DHelpers.extractScale(transformStart, 0);
        this.scaleEnd = Affine3DHelpers.extractScale(transformEnd, 0);
        this.scaleDiff = this.scaleEnd - this.scaleStart;
        this.scaleRate = this.scaleEnd / this.scaleStart;
        double[] tStart = new double[3];
        double[] tEnd = new double[3];
        for (int d = 0; d < 3; ++d) {
            tStart[d] = transformStart.get(d, 3) / this.scaleStart;
            tEnd[d] = transformEnd.get(d, 3) / this.scaleEnd;
        }
        this.xg0Start = new double[3];
        double[] xg0End = new double[3];
        this.xg0Diff = new double[3];
        double[][] R = new double[3][3];
        LinAlgHelpers.quaternionToR(qStartInv, R);
        LinAlgHelpers.mult(R, tStart, this.xg0Start);
        LinAlgHelpers.scale(this.xg0Start, -1.0, this.xg0Start);
        LinAlgHelpers.quaternionToR(qEndInv, R);
        LinAlgHelpers.mult(R, tEnd, xg0End);
        LinAlgHelpers.scale(xg0End, -1.0, xg0End);
        LinAlgHelpers.subtract(xg0End, this.xg0Start, this.xg0Diff);
    }

    @Override
    public AffineTransform3D get(double t) {
        double[] qDiffCurrent = new double[4];
        double[] qCurrent = new double[4];
        LinAlgHelpers.quaternionPower(this.qDiff, t, qDiffCurrent);
        LinAlgHelpers.quaternionMultiply(this.qStart, qDiffCurrent, qCurrent);
        double alpha = Math.pow(this.scaleRate, t);
        double scaleCurrent = this.scaleStart * alpha;
        double[] xg0Current = new double[3];
        double[] tCurrent = new double[3];
        double f = Math.abs(this.scaleRate - 1.0) < 1.0E-4 ? -t : (this.scaleEnd / alpha - this.scaleEnd) / this.scaleDiff;
        LinAlgHelpers.scale(this.xg0Diff, f, xg0Current);
        for (int r = 0; r < 3; ++r) {
            int n = r;
            xg0Current[n] = xg0Current[n] - this.xg0Start[r];
        }
        double[][] Rcurrent = new double[3][3];
        LinAlgHelpers.quaternionToR(qCurrent, Rcurrent);
        LinAlgHelpers.mult(Rcurrent, xg0Current, tCurrent);
        double[][] m = new double[3][4];
        for (int r = 0; r < 3; ++r) {
            for (int c = 0; c < 3; ++c) {
                m[r][c] = scaleCurrent * Rcurrent[r][c];
            }
            m[r][3] = scaleCurrent * tCurrent[r];
        }
        double[] dArray = m[0];
        dArray[3] = dArray[3] + this.cX;
        double[] dArray2 = m[1];
        dArray2[3] = dArray2[3] + this.cY;
        AffineTransform3D transform = new AffineTransform3D();
        transform.set(m);
        return transform;
    }
}

