/*
 * Decompiled with CFR 0.152.
 */
package FlowJ;

import FlowJ.FlowJException;
import FlowJ.FlowJFlow;
import FlowJ.SSD;
import bijnum.BIJJacobi;
import bijnum.BIJmatrix;
import bijnum.Jacobi;
import ij.IJ;
import ij.ImageStack;
import volume.Gaussian;
import volume.VolumeFloat;

public class FlowJSingh {
    public final boolean debug = false;
    private final int N = 4;
    private final int n = 2;
    private float tau1;
    private float tau2;
    private final int i = 10;
    private final int w = 2;
    private final float DIFF_THRESH = 1.0E-5f;
    private final int edge = 10;
    private float sigmas;
    private float density;
    private int width;
    private int height;
    private int depth;
    private VolumeFloat v;
    private float[][][][] Scc;
    private float[][][] Ucc;
    private float[] pixels;

    public String toString() {
        return "S s" + this.sigmas + " tau1" + this.tau1 + " tau2" + this.tau2 + " N" + 4 + " n" + 2 + " i" + 10 + " w" + 2 + " (" + IJ.d2s((double)(this.density * 100.0f), (int)2) + "%)";
    }

    public void filterAll(ImageStack stack, int center, float sigmas) throws FlowJException {
        this.width = stack.getWidth();
        this.height = stack.getHeight();
        this.depth = 3;
        this.sigmas = sigmas;
        IJ.log((String)("Singh: laplace convolution sigma " + sigmas));
        this.v = new VolumeFloat(this.width, this.height, this.depth);
        if (stack.getSize() < this.depth) {
            FlowJException e = new FlowJException("Need at least " + this.depth + " slices.");
            throw e;
        }
        if (center < this.depth / 2) {
            FlowJException e = new FlowJException("Please select a slice over " + this.depth / 2 + " and below " + this.depth / 2);
            throw e;
        }
        Gaussian sGaussian = new Gaussian(sigmas);
        this.v.load(stack, center - this.depth / 2);
        VolumeFloat vc = new VolumeFloat(this.width, this.height, this.depth);
        VolumeFloat vcc = new VolumeFloat(this.width, this.height, this.depth);
        vc.convolvex(this.v, sGaussian);
        vcc.convolvey(vc, sGaussian);
        this.v.sub(vcc);
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public void compute1(FlowJFlow flow, float tau1) {
        int total = 0;
        int full = 0;
        this.Scc = new float[this.height][this.width][2][2];
        this.Ucc = new float[this.height][this.width][2];
        this.tau1 = tau1;
        IJ.showStatus((String)"Singh...");
        IJ.log((String)("Singh: step 1 tau = " + tau1));
        flow.v.setEdge(10);
        for (int y = 0; y < this.height; ++y) {
            IJ.showProgress((double)((float)y / (float)this.height));
            for (int x = 0; x < this.width; ++x) {
                this.Ucc[y][x][1] = 100.0f;
                this.Ucc[y][x][0] = 100.0f;
                this.Scc[y][x][1][1] = 100.0f;
                this.Scc[y][x][1][0] = 100.0f;
                this.Scc[y][x][0][1] = 100.0f;
                this.Scc[y][x][0][0] = 100.0f;
                flow.set(x, y, 0.0f, 0.0f, false);
                if (!flow.valid(x, y)) continue;
                SSD ssdl = new SSD(this.v, 17, 2, -1, x, y);
                SSD ssdr = new SSD(this.v, 17, 2, 1, x, y);
                SSD ssd = new SSD(17, 2);
                ssd.add(ssdl, ssdr);
                int[] loc = ssd.peak(x, y);
                SSD ssdc = new SSD(9, 2);
                ssdc.center(ssd, loc);
                float min = ssdc.min();
                float k = (double)min < 1.0E-6 ? 0.0085f : -((float)Math.log(0.95)) / min;
                ssdc.recompute(k);
                float[][] covariance = new float[2][2];
                float[] mean = new float[2];
                ssdc.mean(4, loc, mean, covariance, x, y);
                float step_size = 1.0f;
                this.Scc[y][x][0][0] = covariance[0][0];
                this.Scc[y][x][0][1] = covariance[0][1];
                this.Scc[y][x][1][0] = covariance[1][0];
                this.Scc[y][x][1][1] = covariance[1][1];
                this.Ucc[y][x][0] = mean[0] / 1.0f;
                this.Ucc[y][x][1] = -(mean[1] / 1.0f);
                float[][] mi = null;
                BIJJacobi j = null;
                try {
                    j = new BIJJacobi(covariance, true);
                }
                catch (Exception e) {
                    IJ.log((String)("Inverse or Jacobi error " + e));
                }
                j.compute();
                j.sort();
                if (tau1 == 0.0f || j.eigenvalues[0] < tau1) {
                    flow.set(x, y, this.Ucc[y][x][0], this.Ucc[y][x][1]);
                    ++full;
                }
                ++total;
            }
        }
        this.density = (float)full / (float)total;
    }

    public void compute2(FlowJFlow flow, float tau2) {
        this.tau2 = tau2;
        IJ.showStatus((String)"Singh...");
        IJ.log((String)("Singh: step 2 tau = " + tau2));
        int total = 0;
        int full = 0;
        int FIRST = 0;
        int SECOND = 1;
        float[][][][] Un = new float[2][this.height][this.width][2];
        for (int y = 0; y < this.height; ++y) {
            for (int x = 0; x < this.width; ++x) {
                float f = this.Ucc[y][x][0];
                Un[SECOND][y][x][0] = f;
                Un[FIRST][y][x][0] = f;
                float f2 = this.Ucc[y][x][1];
                Un[SECOND][y][x][1] = f2;
                Un[FIRST][y][x][1] = f2;
            }
        }
        Gaussian G = new Gaussian(5);
        float[][] Wm = new float[5][5];
        float s = 0.0f;
        for (int k = 0; k <= 4; ++k) {
            for (int j = 0; j <= 4; ++j) {
                Wm[k][j] = (float)(G.k[k] * G.k[j]);
                s += Wm[k][j];
            }
        }
        float[][][][] SccI = new float[this.height][this.width][2][2];
        float[][][][] SccI_Ucc = new float[this.height][this.width][2][2];
        float[][][] Ua = new float[this.height][this.width][2];
        float[][][][][] Sn = new float[2][this.height][this.width][2][2];
        for (int y = 0; y < this.height; ++y) {
            for (int x = 0; x < this.width; ++x) {
                if (x < 12 || x >= this.width - 10 - 2 || y < 12 || y >= this.height - 10 - 2) continue;
                try {
                    BIJmatrix.pseudoinverse(SccI[y][x], this.Scc[y][x], 0.1);
                }
                catch (Exception e) {
                    IJ.log((String)"init inverse error");
                }
                BIJmatrix.mul(SccI_Ucc[y][x][0], SccI[y][x], this.Ucc[y][x]);
                float[][][] neighborhood = new float[5][5][2];
                for (int k = -2; k <= 2; ++k) {
                    for (int l = -2; l <= 2; ++l) {
                        if (Un[FIRST][y + k][x + l][0] == 100.0f || Un[FIRST][y + k][x + l][1] == 100.0f) continue;
                        neighborhood[k + 2][l + 2][0] = Un[FIRST][y + k][x + l][0];
                        neighborhood[k + 2][l + 2][1] = Un[FIRST][y + k][x + l][1];
                    }
                }
                FlowJSingh.calc_mean_and_covariance2(Wm, neighborhood, Ua[y][x], Sn[FIRST][y][x]);
            }
        }
        float max_diff = 0.0f;
        this.Scc = null;
        this.Ucc = null;
        float[][][][] ScSn = new float[this.height][this.width][2][2];
        for (int n = 0; n < 10; ++n) {
            int x;
            int y;
            boolean stop = false;
            for (y = 0; y < this.height; ++y) {
                IJ.showProgress((double)((float)y / (float)this.height));
                for (x = 0; x < this.width; ++x) {
                    if (x < 12 || x >= this.width - 10 - 2 || y < 12 || y >= this.height - 10 - 2) continue;
                    float[][] SnI = new float[2][2];
                    try {
                        BIJmatrix.pseudoinverse(SnI, Sn[FIRST][y][x], 0.1);
                    }
                    catch (Exception e) {
                        IJ.log((String)("iter " + n + " inverse error"));
                    }
                    float[][] Ssum = new float[2][2];
                    BIJmatrix.add(Ssum, Sn[FIRST][y][x], SnI);
                    try {
                        BIJmatrix.pseudoinverse(ScSn[y][x], Ssum, 0.1);
                    }
                    catch (Exception e) {
                        IJ.log((String)("iter 2, " + n + " inverse error"));
                    }
                    float[] vt1 = new float[2];
                    BIJmatrix.mul(vt1, SnI, Ua[y][x]);
                    float[] vt2 = BIJmatrix.addElements(SccI_Ucc[y][x][0], vt1);
                    BIJmatrix.mul(Un[SECOND][y][x], ScSn[y][x], vt2);
                    float[] diff = new float[]{Un[FIRST][y][x][0] - Un[SECOND][y][x][0], Un[FIRST][y][x][1] - Un[SECOND][y][x][1]};
                    float size = BIJmatrix.norm(diff);
                    if (size > max_diff) {
                        max_diff = size;
                    }
                    stop = size > 1.0E-5f;
                }
            }
            if (stop) {
                IJ.log((String)("Step 2 convergence (" + n + ") detected - iterative calculations are stopped"));
                break;
            }
            for (y = 0; y < this.height; ++y) {
                for (x = 0; x < this.width; ++x) {
                    if (x < 12 || x >= this.width - 10 - 2 || y < 12 || y >= this.height - 10 - 2) continue;
                    float[][][] neighborhood = new float[5][5][2];
                    for (int k = -2; k <= 2; ++k) {
                        for (int l = -2; l <= 2; ++l) {
                            if (Un[SECOND][y + k][x + l][0] == 100.0f || Un[SECOND][y + k][x + l][1] == 100.0f) continue;
                            neighborhood[k + 2][l + 2][0] = Un[SECOND][y + k][x + l][0];
                            neighborhood[k + 2][l + 2][1] = Un[SECOND][y + k][x + l][1];
                        }
                    }
                    FlowJSingh.calc_mean_and_covariance2(Wm, neighborhood, Ua[y][x], Sn[SECOND][y][x]);
                }
            }
            int temp = FIRST;
            FIRST = SECOND;
            SECOND = temp;
        }
        int no_vels = 0;
        for (int y = 10; y < this.height - 10; ++y) {
            for (int x = 10; x < this.width - 10; ++x) {
                if (x < 12 || x >= this.width - 10 - 2 || y < 12 || y >= this.height - 10 - 2) continue;
                flow.set(x, y, 0.0f, 0.0f, false);
                Jacobi j = new Jacobi(2);
                j.compute(ScSn[y][x]);
                j.sort();
                if ((tau2 == 0.0f || j.eigenvalues[0] < (double)tau2) && Un[FIRST][y][x][0] != 100.0f && Un[FIRST][y][x][1] != 100.0f) {
                    ++no_vels;
                    flow.set(x, y, Un[FIRST][y][x][0], Un[FIRST][y][x][1]);
                    ++full;
                }
                ++total;
            }
        }
        IJ.log((String)("step 2 complete. Valid computations: " + no_vels));
        this.density = (float)full / (float)total;
    }

    private static void calc_mean_and_covariance2(float[][] weights, float[][][] velocities, float[] mean, float[][] covariance) {
        int j;
        int k;
        float w_sum = 0.0f;
        for (k = 0; k < weights.length; ++k) {
            for (j = 0; j < weights.length; ++j) {
                if (velocities[k][j][0] == 100.0f || velocities[k][j][1] == 100.0f) continue;
                w_sum += weights[k][j];
                mean[0] = mean[0] + weights[k][j] * velocities[k][j][0];
                mean[1] = mean[1] + weights[k][j] * velocities[k][j][1];
            }
        }
        for (k = 0; k < 2; ++k) {
            for (j = 0; j < 2; ++j) {
                covariance[k][j] = 0.0f;
            }
        }
        for (k = 0; k < weights.length; ++k) {
            for (j = 0; j < weights.length; ++j) {
                if (velocities[k][j][0] == 100.0f || velocities[k][j][1] == 100.0f) continue;
                float[] fArray = covariance[0];
                fArray[0] = fArray[0] + (velocities[k][j][0] - mean[0]) * (velocities[k][j][0] - mean[0]) * weights[k][j];
                float[] fArray2 = covariance[1];
                fArray2[1] = fArray2[1] + (velocities[k][j][1] - mean[1]) * (velocities[k][j][1] - mean[1]) * weights[k][j];
                float[] fArray3 = covariance[0];
                fArray3[1] = fArray3[1] + (velocities[k][j][0] - mean[0]) * (velocities[k][j][1] - mean[1]) * weights[k][j];
            }
        }
        float[] fArray = covariance[0];
        fArray[0] = fArray[0] / w_sum;
        float[] fArray4 = covariance[0];
        fArray4[1] = fArray4[1] / w_sum;
        float[] fArray5 = covariance[1];
        fArray5[1] = fArray5[1] / w_sum;
        covariance[1][0] = covariance[0][1];
    }
}

