/*
 * Decompiled with CFR 0.152.
 */
package bijnum;

public class BIJShortMatrix {
    public static float[] minmax(short[] v) {
        float[] minmax = new float[]{32767.0f, -32767.0f};
        for (int j = 0; j < v.length; ++j) {
            float val = v[j] & 0xFFFF;
            if (val < minmax[0]) {
                minmax[0] = val;
                continue;
            }
            if (!(val > minmax[1])) continue;
            minmax[1] = val;
        }
        return minmax;
    }

    public static float[] minmax(short[][] m) {
        int iN = m.length;
        int iM = m[0].length;
        float[] minmax = new float[]{32767.0f, -32767.0f};
        for (int j = 0; j < iN; ++j) {
            for (int i = 0; i < iM; ++i) {
                float val = m[j][i] & 0xFFFF;
                if (val < minmax[0]) {
                    minmax[0] = val;
                    continue;
                }
                if (!(val > minmax[1])) continue;
                minmax[1] = val;
            }
        }
        return minmax;
    }

    public static float mean(short[] v) {
        double cum = 0.0;
        int iN = v.length;
        for (int j = 0; j < iN; ++j) {
            cum += (double)(v[j] & 0xFFFF);
        }
        return (float)(cum / (double)iN);
    }

    public static short[] copy(short[] v) {
        int iN = v.length;
        short[] nv = new short[iN];
        for (int i = 0; i < iN; ++i) {
            nv[i] = v[i];
        }
        return nv;
    }

    public static short[] add(short[] v, float scalar) {
        int iN = v.length;
        for (int j = 0; j < iN; ++j) {
            v[j] = (short)Math.round((float)(v[j] & 0xFFFF) + scalar);
        }
        return v;
    }

    public static String toString(short[] v) {
        StringBuffer sb = new StringBuffer("Vector (");
        int iN = v.length;
        sb.append(iN);
        sb.append("):\n");
        for (int j = 0; j < iN; ++j) {
            sb.append(v[j]);
            sb.append("\t");
        }
        return sb.toString();
    }
}

