/*
 * Decompiled with CFR 0.152.
 */
package volume;

import volume.Kernel1D;
import volume.Kernel2D;
import volume.Kernel3D;

public class Convolver {
    public static void convolvexy(float[] plane, int width, int height, Kernel1D kernel) {
        float[] t1 = Convolver.convolvex(plane, width, height, kernel);
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                float d = 0.0f;
                for (int k = -kernel.halfwidth; k <= kernel.halfwidth; ++k) {
                    int xi = x;
                    int yi = y + k;
                    if (xi < 0) {
                        xi = -xi;
                    } else if (xi >= width) {
                        xi = 2 * width - xi - 1;
                    }
                    if (yi < 0) {
                        yi = -yi;
                    } else if (yi >= height) {
                        yi = 2 * height - yi - 1;
                    }
                    float pixel = t1[yi * width + xi];
                    if (pixel == Float.NaN) {
                        d = Float.NaN;
                        break;
                    }
                    d = (float)((double)d + (double)pixel * kernel.k[k + kernel.halfwidth]);
                }
                plane[y * width + x] = d;
            }
        }
    }

    public static float[] convolvex(float[] plane, int width, int height, Kernel1D kernel) {
        float[] result = new float[plane.length];
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                float d = 0.0f;
                for (int k = -kernel.halfwidth; k <= kernel.halfwidth; ++k) {
                    int xi = x + k;
                    int yi = y;
                    if (xi < 0) {
                        xi = -xi;
                    } else if (xi >= width) {
                        xi = 2 * width - xi - 1;
                    }
                    if (yi < 0) {
                        yi = -yi;
                    } else if (yi >= height) {
                        yi = 2 * height - yi - 1;
                    }
                    d = (float)((double)d + (double)plane[yi * width + xi] * kernel.k[k + kernel.halfwidth]);
                }
                result[y * width + x] = d;
            }
        }
        return result;
    }

    public static float[] convolvey(float[] plane, int width, int height, Kernel1D kernel) {
        float[] result = new float[plane.length];
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                float d = 0.0f;
                for (int k = -kernel.halfwidth; k <= kernel.halfwidth; ++k) {
                    int xi = x;
                    int yi = y + k;
                    if (xi < 0) {
                        xi = -xi;
                    } else if (xi >= width) {
                        xi = 2 * width - xi - 1;
                    }
                    if (yi < 0) {
                        yi = -yi;
                    } else if (yi >= height) {
                        yi = 2 * height - yi - 1;
                    }
                    d = (float)((double)d + (double)plane[yi * width + xi] * kernel.k[k + kernel.halfwidth]);
                }
                result[y * width + x] = d;
            }
        }
        return result;
    }

    public static void convolvexy(short[] plane, int width, int height, Kernel1D kernel) {
        int yi;
        int xi;
        int k;
        float d;
        int x;
        int y;
        short[] tl = new short[plane.length];
        for (y = 0; y < height; ++y) {
            for (x = 0; x < width; ++x) {
                d = 0.0f;
                for (k = -kernel.halfwidth; k <= kernel.halfwidth; ++k) {
                    xi = x + k;
                    yi = y;
                    if (xi < 0) {
                        xi = -xi;
                    } else if (xi >= width) {
                        xi = 2 * width - xi - 1;
                    }
                    if (yi < 0) {
                        yi = -yi;
                    } else if (yi >= height) {
                        yi = 2 * height - yi - 1;
                    }
                    d = (float)((double)d + (double)plane[yi * width + xi] * kernel.k[k + kernel.halfwidth]);
                }
                tl[y * width + x] = (short)d;
            }
        }
        for (y = 0; y < height; ++y) {
            for (x = 0; x < width; ++x) {
                d = 0.0f;
                for (k = -kernel.halfwidth; k <= kernel.halfwidth; ++k) {
                    xi = x;
                    yi = y + k;
                    if (xi < 0) {
                        xi = -xi;
                    } else if (xi >= width) {
                        xi = 2 * width - xi - 1;
                    }
                    if (yi < 0) {
                        yi = -yi;
                    } else if (yi >= height) {
                        yi = 2 * height - yi - 1;
                    }
                    d = (float)((double)d + (double)tl[yi * width + xi] * kernel.k[k + kernel.halfwidth]);
                }
                plane[y * width + x] = (short)d;
            }
        }
    }

    public static void convolvexy(float[] plane, int width, int height, Kernel2D kernel) {
        float[] t1 = new float[plane.length];
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                float d = 0.0f;
                for (int m = -kernel.halfwidth; m <= kernel.halfwidth; ++m) {
                    for (int l = -kernel.halfwidth; l <= kernel.halfwidth; ++l) {
                        int xi = x + l;
                        int yi = y + m;
                        if (xi < 0) {
                            xi = -xi;
                        } else if (xi >= width) {
                            xi = 2 * width - xi - 1;
                        }
                        if (yi < 0) {
                            yi = -yi;
                        } else if (yi >= height) {
                            yi = 2 * height - yi - 1;
                        }
                        d = (float)((double)d + (double)plane[yi * width + xi] * kernel.k[m + kernel.halfwidth][l + kernel.halfwidth]);
                    }
                }
                t1[y * width + x] = d;
            }
        }
        for (int i = 0; i < plane.length; ++i) {
            plane[i] = t1[i];
        }
    }

    public static void convolvexyz(float[] volume, int width, int height, int depth, Kernel3D kernel) {
        float[] t1 = new float[volume.length];
        for (int z = 0; z < depth; ++z) {
            for (int y = 0; y < height; ++y) {
                for (int x = 0; x < width; ++x) {
                    float d = 0.0f;
                    for (int n = -kernel.halfwidth; n <= kernel.halfwidth; ++n) {
                        for (int m = -kernel.halfwidth; m <= kernel.halfwidth; ++m) {
                            for (int l = -kernel.halfwidth; l <= kernel.halfwidth; ++l) {
                                int xi = x + l;
                                int yi = y + m;
                                int zi = z + n;
                                if (xi < 0) {
                                    xi = -xi;
                                } else if (xi >= width) {
                                    xi = 2 * width - xi - 1;
                                }
                                if (yi < 0) {
                                    yi = -yi;
                                } else if (yi >= height) {
                                    yi = 2 * height - yi - 1;
                                }
                                if (zi < 0) {
                                    zi = -zi;
                                } else if (zi >= width) {
                                    zi = 2 * depth - zi - 1;
                                }
                                d = (float)((double)d + (double)volume[zi * height * width + yi * width + xi] * kernel.k[n + kernel.halfwidth][m + kernel.halfwidth][l + kernel.halfwidth]);
                            }
                        }
                    }
                    t1[z * height * width + y * width + x] = d;
                }
            }
        }
        for (int i = 0; i < volume.length; ++i) {
            volume[i] = t1[i];
        }
    }

    public static void convolvex(float[] volume, int width, int height, int depth, Kernel1D kernel) {
        float[] t1 = new float[volume.length];
        for (int z = 0; z < depth; ++z) {
            for (int y = 0; y < height; ++y) {
                for (int x = 0; x < width; ++x) {
                    float d = 0.0f;
                    for (int l = -kernel.halfwidth; l <= kernel.halfwidth; ++l) {
                        int xi = x + l;
                        if (xi < 0) {
                            xi = -xi;
                        } else if (xi >= width) {
                            xi = 2 * width - xi - 1;
                        }
                        d = (float)((double)d + (double)volume[z * height * width + y * width + xi] * kernel.k[l + kernel.halfwidth]);
                    }
                    t1[z * height * width + y * width + x] = d;
                }
            }
        }
        for (int i = 0; i < volume.length; ++i) {
            volume[i] = t1[i];
        }
    }

    public static void convolvey(float[] volume, int width, int height, int depth, Kernel1D kernel) {
        float[] t1 = new float[volume.length];
        for (int z = 0; z < depth; ++z) {
            for (int y = 0; y < height; ++y) {
                for (int x = 0; x < width; ++x) {
                    float d = 0.0f;
                    for (int m = -kernel.halfwidth; m <= kernel.halfwidth; ++m) {
                        int yi = y + m;
                        if (yi < 0) {
                            yi = -yi;
                        } else if (yi >= width) {
                            yi = 2 * width - yi - 1;
                        }
                        d = (float)((double)d + (double)volume[z * height * width + yi * width + x] * kernel.k[m + kernel.halfwidth]);
                    }
                    t1[z * height * width + y * width + x] = d;
                }
            }
        }
        for (int i = 0; i < volume.length; ++i) {
            volume[i] = t1[i];
        }
    }

    public static void convolvez(float[] volume, int width, int height, int depth, Kernel1D kernel) {
        float[] t1 = new float[volume.length];
        for (int z = 0; z < depth; ++z) {
            for (int y = 0; y < height; ++y) {
                for (int x = 0; x < width; ++x) {
                    float d = 0.0f;
                    for (int n = -kernel.halfwidth; n <= kernel.halfwidth; ++n) {
                        int zi = z + n;
                        if (zi < 0) {
                            zi = -zi;
                        } else if (zi >= width) {
                            zi = 2 * width - zi - 1;
                        }
                        d = (float)((double)d + (double)volume[zi * height * width + y * width + x] * kernel.k[n + kernel.halfwidth]);
                    }
                    t1[z * height * width + y * width + x] = d;
                }
            }
        }
        for (int i = 0; i < volume.length; ++i) {
            volume[i] = t1[i];
        }
    }

    public static void convolvexyz(short[] volume, int width, int height, int depth, Kernel3D kernel) {
        short[] t1 = new short[volume.length];
        for (int z = 0; z < depth; ++z) {
            for (int y = 0; y < height; ++y) {
                for (int x = 0; x < width; ++x) {
                    float d = 0.0f;
                    for (int n = -kernel.halfwidth; n <= kernel.halfwidth; ++n) {
                        for (int m = -kernel.halfwidth; m <= kernel.halfwidth; ++m) {
                            for (int l = -kernel.halfwidth; l <= kernel.halfwidth; ++l) {
                                int xi = x + l;
                                int yi = y + m;
                                int zi = z + n;
                                if (xi < 0) {
                                    xi = -xi;
                                } else if (xi >= width) {
                                    xi = 2 * width - xi - 1;
                                }
                                if (yi < 0) {
                                    yi = -yi;
                                } else if (yi >= height) {
                                    yi = 2 * height - yi - 1;
                                }
                                if (zi < 0) {
                                    zi = -zi;
                                } else if (zi >= width) {
                                    zi = 2 * depth - zi - 1;
                                }
                                d = (float)((double)d + (double)volume[zi * height * width + yi * width + xi] * kernel.k[n + kernel.halfwidth][m + kernel.halfwidth][l + kernel.halfwidth]);
                            }
                        }
                    }
                    t1[z * height * width + y * width + x] = (short)d;
                }
            }
        }
        for (int i = 0; i < volume.length; ++i) {
            volume[i] = t1[i];
        }
    }

    public static void magConvolutionxy(float[] plane, int width, int height, Kernel1D kernel) {
        int k;
        int x;
        int y;
        float[] dx = new float[plane.length];
        float[] dy = new float[plane.length];
        for (y = 0; y < height; ++y) {
            for (x = 0; x < width; ++x) {
                dx[y * width + x] = 0.0f;
                if (!Convolver.valid(width, height, x, y, kernel.halfwidth)) continue;
                for (k = -kernel.halfwidth; k <= kernel.halfwidth; ++k) {
                    int n = y * width + x;
                    dx[n] = (float)((double)dx[n] + (double)plane[y * width + (x + k)] * kernel.k[k + kernel.halfwidth]);
                }
            }
        }
        for (y = 0; y < height; ++y) {
            for (x = 0; x < width; ++x) {
                dy[y * width + x] = 0.0f;
                if (!Convolver.valid(width, height, x, y, kernel.halfwidth)) continue;
                for (k = -kernel.halfwidth; k <= kernel.halfwidth; ++k) {
                    int n = y * width + x;
                    dy[n] = (float)((double)dy[n] + (double)plane[(y + k) * width + x] * kernel.k[k + kernel.halfwidth]);
                }
            }
        }
        for (int i = 0; i < plane.length; ++i) {
            plane[i] = (float)Math.sqrt(Math.pow(dx[i], 2.0) + Math.pow(dy[i], 2.0));
        }
    }

    public static void magConvolutionxy(float[] plane, int width, int height, Kernel2D kernel) {
        float[] t1 = new float[plane.length];
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                double dx = 0.0;
                double dy = 0.0;
                if (Convolver.valid(width, height, x, y, kernel.halfwidth)) {
                    for (int m = -kernel.halfwidth; m <= kernel.halfwidth; ++m) {
                        for (int l = -kernel.halfwidth; l <= kernel.halfwidth; ++l) {
                            float pixel = plane[(y + m) * width + (x + l)];
                            dx += (double)pixel * kernel.k[m + kernel.halfwidth][l + kernel.halfwidth];
                            dy += (double)pixel * kernel.k[l + kernel.halfwidth][m + kernel.halfwidth];
                        }
                    }
                }
                t1[y * width + x] = (float)Math.sqrt(dx * dx + dy * dy);
            }
        }
        for (int i = 0; i < plane.length; ++i) {
            plane[i] = t1[i];
        }
    }

    public static void pow(float[] image, double pow) {
        for (int i = 0; i < image.length; ++i) {
            image[i] = (float)Math.pow(image[i], pow);
        }
    }

    public static float[] subtract(float[] image1, float[] image2) {
        float[] r = new float[image1.length];
        for (int i = 0; i < image1.length; ++i) {
            r[i] = image1[i] - image2[i];
        }
        return r;
    }

    public static void nonlinear(float[] image, double threshold) {
        for (int i = 0; i < image.length; ++i) {
            image[i] = (double)image[i] >= threshold ? image[i] : 0.0f;
        }
    }

    public static void normalize(float[] plane, double threshold) {
        for (int i = 0; i < plane.length; ++i) {
            plane[i] = (double)plane[i] >= threshold ? 255.0f : 0.0f;
        }
    }

    public static boolean valid(int width, int height, int x, int y, int edge) {
        return x >= edge && x < width - edge && y >= edge && y < height - edge;
    }

    public static boolean valid(int width, int height, int depth, int x, int y, int z, int edge) {
        return x >= edge && x < width - edge && y >= edge && y < height - edge && z >= edge && z < depth - edge;
    }
}

