/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2;

import java.util.Arrays;
import net.imglib2.EuclideanSpace;
import net.imglib2.Point;
import net.imglib2.Positionable;
import net.imglib2.exception.InvalidDimensionsException;

public interface Dimensions
extends EuclideanSpace {
    default public void dimensions(long[] dimensions) {
        int n = this.numDimensions();
        for (int d = 0; d < n; ++d) {
            dimensions[d] = this.dimension(d);
        }
    }

    default public void dimensions(Positionable dimensions) {
        int n = this.numDimensions();
        for (int d = 0; d < n; ++d) {
            dimensions.setPosition(this.dimension(d), d);
        }
    }

    public long dimension(int var1);

    default public long[] dimensionsAsLongArray() {
        long[] dims = new long[this.numDimensions()];
        this.dimensions(dims);
        return dims;
    }

    default public Point dimensionsAsPoint() {
        return new Point(this.dimensionsAsLongArray());
    }

    public static boolean allPositive(long ... dimensions) {
        for (long d : dimensions) {
            if (d >= 1L) continue;
            return false;
        }
        return true;
    }

    public static boolean allPositive(int ... dimensions) {
        for (int d : dimensions) {
            if (d >= 1) continue;
            return false;
        }
        return true;
    }

    public static long[] verifyAllPositive(long ... dimensions) throws InvalidDimensionsException {
        if (!Dimensions.allPositive(dimensions)) {
            throw new InvalidDimensionsException(dimensions, "Expected only positive dimensions but got: " + Arrays.toString(dimensions));
        }
        return dimensions;
    }

    public static int[] verifyAllPositive(int ... dimensions) throws InvalidDimensionsException {
        if (!Dimensions.allPositive(dimensions)) {
            throw new InvalidDimensionsException(dimensions, "Expected only positive dimensions but got: " + Arrays.toString(dimensions));
        }
        return dimensions;
    }

    public static long[] verify(long ... dimensions) throws InvalidDimensionsException {
        if (dimensions == null) {
            throw new InvalidDimensionsException(dimensions, "Dimensions are null.");
        }
        if (dimensions.length == 0) {
            throw new InvalidDimensionsException(dimensions, "Dimensions are zero length.");
        }
        return Dimensions.verifyAllPositive(dimensions);
    }

    public static int[] verify(int ... dimensions) throws InvalidDimensionsException {
        if (dimensions == null) {
            throw new InvalidDimensionsException(dimensions, "Dimensions are null.");
        }
        if (dimensions.length == 0) {
            throw new InvalidDimensionsException(dimensions, "Dimensions are zero length.");
        }
        return Dimensions.verifyAllPositive(dimensions);
    }
}

