/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.blocks;

import java.util.Arrays;
import net.imglib2.Interval;
import net.imglib2.util.Util;

public final class BlockInterval
implements Interval {
    private final long[] min;
    private final int[] size;

    public BlockInterval(int numDimensions) {
        this(new long[numDimensions], new int[numDimensions]);
    }

    public static BlockInterval wrap(long[] min, int[] size) {
        return new BlockInterval(min, size);
    }

    public static BlockInterval asBlockInterval(Interval interval) {
        return interval instanceof BlockInterval ? (BlockInterval)interval : new BlockInterval(interval);
    }

    private BlockInterval(long[] min, int[] size) {
        this.min = min;
        this.size = size;
    }

    private BlockInterval(Interval interval) {
        this(interval.numDimensions());
        interval.min(this.min);
        Arrays.setAll(this.size, d -> Util.safeInt(interval.dimension(d)));
    }

    public void setFrom(Interval interval) {
        int n = this.numDimensions();
        if (n != interval.numDimensions()) {
            throw new IllegalArgumentException("Interval dimensions mismatch");
        }
        if (interval instanceof BlockInterval) {
            System.arraycopy(((BlockInterval)interval).min, 0, this.min, 0, n);
            System.arraycopy(((BlockInterval)interval).size, 0, this.size, 0, n);
        }
        for (int d = 0; d < n; ++d) {
            this.min[d] = interval.min(d);
            this.size[d] = Util.safeInt(interval.dimension(d));
        }
    }

    public long[] min() {
        return this.min;
    }

    public int[] size() {
        return this.size;
    }

    @Override
    public int numDimensions() {
        return this.size.length;
    }

    @Override
    public long min(int d) {
        return this.min[d];
    }

    @Override
    public long max(int d) {
        return this.min[d] + (long)this.size[d] - 1L;
    }

    @Override
    public long dimension(int d) {
        return this.size[d];
    }
}

