/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.img.list;

import net.imglib2.AbstractCursor;
import net.imglib2.AbstractLocalizable;
import net.imglib2.AbstractLocalizingCursor;
import net.imglib2.FlatIterationOrder;
import net.imglib2.Localizable;
import net.imglib2.RandomAccess;
import net.imglib2.img.AbstractImg;
import net.imglib2.util.IntervalIndexer;

public abstract class AbstractLongListImg<T>
extends AbstractImg<T> {
    protected final long[] step;

    protected AbstractLongListImg(long[] dimensions) {
        super(dimensions);
        this.step = new long[this.n];
        IntervalIndexer.createAllocationSteps(this.dimension, this.step);
    }

    protected abstract T get(long var1);

    protected abstract void set(long var1, T var3);

    @Override
    public LongListCursor cursor() {
        return new LongListCursor();
    }

    @Override
    public LongListLocalizingCursor localizingCursor() {
        return new LongListLocalizingCursor();
    }

    public LongListRandomAccess randomAccess() {
        return new LongListRandomAccess();
    }

    @Override
    public FlatIterationOrder iterationOrder() {
        return new FlatIterationOrder(this);
    }

    public class LongListRandomAccess
    extends AbstractLocalizable
    implements RandomAccess<T> {
        private long i;

        public LongListRandomAccess(LongListRandomAccess randomAccess) {
            super(randomAccess.numDimensions());
            for (int d = 0; d < this.n; ++d) {
                this.position[d] = randomAccess.position[d];
            }
            this.i = randomAccess.i;
        }

        public LongListRandomAccess() {
            super(AbstractLongListImg.this.numDimensions());
            this.i = 0L;
        }

        @Override
        public T get() {
            return AbstractLongListImg.this.get(this.i);
        }

        @Override
        public T getType() {
            return AbstractLongListImg.this.getType();
        }

        public void set(T t) {
            AbstractLongListImg.this.set(this.i, t);
        }

        @Override
        public void fwd(int d) {
            this.i += AbstractLongListImg.this.step[d];
            int n = d;
            this.position[n] = this.position[n] + 1L;
        }

        @Override
        public void bck(int d) {
            this.i -= AbstractLongListImg.this.step[d];
            int n = d;
            this.position[n] = this.position[n] - 1L;
        }

        @Override
        public void move(int distance, int d) {
            this.i += AbstractLongListImg.this.step[d] * (long)distance;
            int n = d;
            this.position[n] = this.position[n] + (long)distance;
        }

        @Override
        public void move(long distance, int d) {
            this.i += AbstractLongListImg.this.step[d] * distance;
            int n = d;
            this.position[n] = this.position[n] + distance;
        }

        @Override
        public void move(Localizable localizable) {
            for (int d = 0; d < this.n; ++d) {
                this.move(localizable.getLongPosition(d), d);
            }
        }

        @Override
        public void move(int[] distance) {
            for (int d = 0; d < this.n; ++d) {
                this.move(distance[d], d);
            }
        }

        @Override
        public void move(long[] distance) {
            for (int d = 0; d < this.n; ++d) {
                this.move(distance[d], d);
            }
        }

        @Override
        public void setPosition(Localizable localizable) {
            this.position[0] = this.i = localizable.getLongPosition(0);
            for (int d = 1; d < this.n; ++d) {
                this.position[d] = localizable.getLongPosition(d);
                this.i += this.position[d] * AbstractLongListImg.this.step[d];
            }
        }

        @Override
        public void setPosition(int[] position) {
            this.position[0] = this.i = (long)position[0];
            for (int d = 1; d < this.n; ++d) {
                long p = position[d];
                this.i += p * AbstractLongListImg.this.step[d];
                this.position[d] = p;
            }
        }

        @Override
        public void setPosition(long[] position) {
            this.position[0] = this.i = position[0];
            for (int d = 1; d < this.n; ++d) {
                long p = position[d];
                this.i += p * AbstractLongListImg.this.step[d];
                this.position[d] = p;
            }
        }

        @Override
        public void setPosition(int position, int d) {
            this.i += AbstractLongListImg.this.step[d] * ((long)position - this.position[d]);
            this.position[d] = position;
        }

        @Override
        public void setPosition(long position, int d) {
            this.i += AbstractLongListImg.this.step[d] * (position - this.position[d]);
            this.position[d] = position;
        }

        @Override
        public LongListRandomAccess copy() {
            return new LongListRandomAccess(this);
        }
    }

    public class LongListLocalizingCursor
    extends AbstractLocalizingCursor<T> {
        private long i;
        private final long maxNumPixels;
        private final long[] max;

        public LongListLocalizingCursor(LongListLocalizingCursor cursor) {
            super(cursor.numDimensions());
            this.maxNumPixels = cursor.maxNumPixels;
            this.max = new long[this.n];
            for (int d = 0; d < this.n; ++d) {
                this.max[d] = cursor.max[d];
                this.position[d] = cursor.position[d];
            }
            this.i = cursor.i;
        }

        public LongListLocalizingCursor() {
            super(AbstractLongListImg.this.numDimensions());
            this.maxNumPixels = AbstractLongListImg.this.size() - 1L;
            this.max = new long[this.n];
            AbstractLongListImg.this.max(this.max);
            this.reset();
        }

        @Override
        public void fwd() {
            ++this.i;
            for (int d = 0; d < this.n; ++d) {
                int n = d;
                this.position[n] = this.position[n] + 1L;
                if (this.position[n] <= this.max[d]) break;
                this.position[d] = 0L;
            }
        }

        @Override
        public void jumpFwd(long steps) {
            this.i += steps;
            IntervalIndexer.indexToPosition(this.i, AbstractLongListImg.this.dimension, this.position);
        }

        @Override
        public boolean hasNext() {
            return this.i < this.maxNumPixels;
        }

        @Override
        public void reset() {
            this.i = -1L;
            this.position[0] = -1L;
            for (int d = 1; d < this.n; ++d) {
                this.position[d] = 0L;
            }
        }

        @Override
        public T get() {
            return AbstractLongListImg.this.get(this.i);
        }

        @Override
        public T getType() {
            return AbstractLongListImg.this.getType();
        }

        public void set(T t) {
            AbstractLongListImg.this.set(this.i, t);
        }

        @Override
        public LongListLocalizingCursor copy() {
            return new LongListLocalizingCursor(this);
        }
    }

    public class LongListCursor
    extends AbstractCursor<T> {
        private long i;
        private final long maxNumPixels;

        protected LongListCursor(LongListCursor cursor) {
            super(cursor.numDimensions());
            this.maxNumPixels = cursor.maxNumPixels;
            this.i = cursor.i;
        }

        public LongListCursor() {
            super(AbstractLongListImg.this.numDimensions());
            this.maxNumPixels = AbstractLongListImg.this.size() - 1L;
            this.reset();
        }

        @Override
        public T get() {
            return AbstractLongListImg.this.get(this.i);
        }

        @Override
        public T getType() {
            return AbstractLongListImg.this.getType();
        }

        public void set(T t) {
            AbstractLongListImg.this.set(this.i, t);
        }

        @Override
        public LongListCursor copy() {
            return new LongListCursor(this);
        }

        @Override
        public boolean hasNext() {
            return this.i < this.maxNumPixels;
        }

        @Override
        public void jumpFwd(long steps) {
            this.i += steps;
        }

        @Override
        public void fwd() {
            ++this.i;
        }

        @Override
        public void reset() {
            this.i = -1L;
        }

        @Override
        public void localize(long[] position) {
            IntervalIndexer.indexToPosition(this.i, AbstractLongListImg.this.dimension, position);
        }

        @Override
        public long getLongPosition(int d) {
            return IntervalIndexer.indexToPosition(this.i, AbstractLongListImg.this.dimension, AbstractLongListImg.this.step, d);
        }
    }
}

