/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.outofbounds;

import net.imglib2.Interval;
import net.imglib2.RandomAccessible;
import net.imglib2.Typed;
import net.imglib2.outofbounds.OutOfBoundsMirrorSingleBoundary;
import net.imglib2.type.Type;
import net.imglib2.type.numeric.NumericType;
import net.imglib2.util.Util;

public class OutOfBoundsMirrorExpWindowing<T extends NumericType<T>>
extends OutOfBoundsMirrorSingleBoundary<T> {
    final T type;
    final float[][] weights;
    protected final long[] max;
    final float exponent;
    final int[] fadeOutDistance;

    public OutOfBoundsMirrorExpWindowing(OutOfBoundsMirrorExpWindowing<T> outOfBounds) {
        super(outOfBounds);
        this.type = (NumericType)outOfBounds.type.createVariable();
        this.fadeOutDistance = outOfBounds.fadeOutDistance;
        this.exponent = outOfBounds.exponent;
        this.max = (long[])outOfBounds.max.clone();
        this.weights = (float[][])outOfBounds.weights.clone();
    }

    public <F extends Interval & RandomAccessible<T>> OutOfBoundsMirrorExpWindowing(F f, int[] fadeOutDistance, float exponent) {
        super(f);
        this.type = (NumericType)((NumericType)((Typed)f).getType()).createVariable();
        this.fadeOutDistance = fadeOutDistance;
        this.exponent = exponent;
        this.max = new long[this.n];
        f.max(this.max);
        this.weights = OutOfBoundsMirrorExpWindowing.preComputeWeights(this.n, fadeOutDistance, exponent);
    }

    protected static final float[][] preComputeWeights(int n, int[] fadeOutDistance, float exponent) {
        int d;
        float[][] weights = new float[n][];
        for (d = 0; d < n; ++d) {
            weights[d] = new float[Math.max(1, fadeOutDistance[d])];
        }
        for (d = 0; d < n; ++d) {
            int maxDistance = weights[d].length;
            if (maxDistance > 1) {
                for (int pos = 0; pos < maxDistance; ++pos) {
                    float relPos = (float)pos / (float)(maxDistance - 1);
                    weights[d][pos] = Util.isApproxEqual(exponent, 1.0f, 1.0E-4f) ? 1.0f - relPos : (float)(1.0 - 1.0 / Math.pow(exponent, 1.0f - relPos)) * (1.0f + 1.0f / (exponent - 1.0f));
                }
                continue;
            }
            weights[d][0] = 0.0f;
        }
        return weights;
    }

    @Override
    public T get() {
        if (this.isOutOfBounds()) {
            this.type.set((Type)((Type)this.outOfBoundsRandomAccess.get()));
            this.type.mul(this.getWeight(this.zeroMinPos));
            return this.type;
        }
        return (T)((NumericType)this.outOfBoundsRandomAccess.get());
    }

    protected final float getWeight(long[] zeroMinPosition) {
        float weight = 1.0f;
        for (int d = 0; d < this.n; ++d) {
            int distance;
            int pos = (int)zeroMinPosition[d];
            if (pos < 0) {
                distance = -pos - 1;
            } else {
                if ((long)pos < this.dimension[d]) continue;
                distance = pos - (int)this.dimension[d];
            }
            if (distance < this.weights[d].length) {
                weight *= this.weights[d][distance];
                continue;
            }
            return 0.0f;
        }
        return weight;
    }

    @Override
    public OutOfBoundsMirrorExpWindowing<T> copy() {
        return new OutOfBoundsMirrorExpWindowing<T>(this);
    }
}

