/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.transform.integer;

import net.imglib2.FinalInterval;
import net.imglib2.Interval;

public final class BoundingBox {
    public final int n;
    public final long[] corner1;
    public final long[] corner2;

    public BoundingBox(int n) {
        this.n = n;
        this.corner1 = new long[n];
        this.corner2 = new long[n];
    }

    public BoundingBox(long[] corner1, long[] corner2) {
        assert (corner1.length == corner2.length);
        this.n = corner1.length;
        this.corner1 = (long[])corner1.clone();
        this.corner2 = (long[])corner2.clone();
    }

    public BoundingBox(Interval interval) {
        this.n = interval.numDimensions();
        this.corner1 = new long[this.n];
        this.corner2 = new long[this.n];
        interval.min(this.corner1);
        interval.max(this.corner2);
    }

    public int numDimensions() {
        return this.n;
    }

    public void corner1(long[] c) {
        assert (c.length >= this.n);
        for (int d = 0; d < this.n; ++d) {
            c[d] = this.corner1[d];
        }
    }

    public void corner2(long[] c) {
        assert (c.length >= this.n);
        for (int d = 0; d < this.n; ++d) {
            c[d] = this.corner2[d];
        }
    }

    public void orderMinMax() {
        for (int d = 0; d < this.n; ++d) {
            if (this.corner1[d] <= this.corner2[d]) continue;
            long tmp = this.corner1[d];
            this.corner1[d] = this.corner2[d];
            this.corner2[d] = tmp;
        }
    }

    public Interval getInterval() {
        this.orderMinMax();
        return new FinalInterval(this.corner1, this.corner2);
    }
}

