/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.util;

public class Binning {
    public static int valueToBin(int bins, double min, double max, double value) {
        int bin = Binning.exclusiveValueToBin(bins, min, max, value);
        bin = Math.max(bin, 0);
        bin = Math.min(bin, bins - 1);
        return bin;
    }

    public static int exclusiveValueToBin(int bins, double min, double max, double value) {
        int bin;
        if (max != min) {
            if (value != max) {
                double temp = (value - min) / (max - min);
                bin = (int)Math.floor(temp * (double)bins);
            } else {
                bin = bins - 1;
            }
        } else {
            bin = bins / 2;
        }
        return bin;
    }

    public static double[] edgeValuesPerBin(int bins, double min, double max) {
        double[] edgeValues = new double[bins];
        for (int i = 0; i < bins; ++i) {
            edgeValues[i] = min + (max - min) * (double)i / (double)bins;
        }
        return edgeValues;
    }

    public static double[] centerValuesPerBin(int bins, double min, double max) {
        double[] edgeValues = Binning.edgeValuesPerBin(bins, min, max);
        double[] centerValues = new double[bins];
        for (int i = 0; i < bins - 1; ++i) {
            centerValues[i] = (edgeValues[i] + edgeValues[i + 1]) / 2.0;
        }
        centerValues[bins - 1] = (edgeValues[bins - 1] + max) / 2.0;
        return centerValues;
    }
}

