/*
 * Decompiled with CFR 0.152.
 */
package customnode;

import customnode.FullInfoMesh;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import org.jogamp.vecmath.Point3f;
import org.jogamp.vecmath.Tuple3f;
import org.jogamp.vecmath.Vector3f;

public class EdgeContraction {
    private final boolean LENGTH_ONLY;
    private final ArrayList<FullInfoMesh> mesh;
    private final SortedSet<CEdge> queue;
    private final Map<CEdge, Float> edgeCosts = new HashMap<CEdge, Float>();
    private final Vector3f v1 = new Vector3f();
    private final Vector3f v2 = new Vector3f();

    public final void removeUntil(float maxCost) {
        CEdge e;
        while (!this.queue.isEmpty() && !(this.edgeCosts.get(e = this.queue.first()).floatValue() > maxCost)) {
            this.queue.remove(e);
            this.fuse(e);
        }
    }

    public final int removeNext(int n) {
        int curr = this.getRemainingVertexCount();
        int goal = curr - n;
        while (curr > goal && !this.queue.isEmpty()) {
            CEdge e = this.queue.first();
            this.queue.remove(e);
            this.fuse(e);
            curr = this.getRemainingVertexCount();
        }
        int v = 0;
        for (int i = 0; i < this.mesh.size(); ++i) {
            v += this.mesh.get(i).getVertexCount();
        }
        return v;
    }

    public int getRemainingVertexCount() {
        int v = 0;
        for (int i = 0; i < this.mesh.size(); ++i) {
            v += this.mesh.get(i).getVertexCount();
        }
        return v;
    }

    public final FullInfoMesh.Edge nextToRemove() {
        return this.queue.first().edge;
    }

    public final int getVertexCount() {
        int v = 0;
        for (FullInfoMesh m : this.mesh) {
            v += m.getVertexCount();
        }
        return v;
    }

    private static final ArrayList<FullInfoMesh> makeList(FullInfoMesh m) {
        ArrayList<FullInfoMesh> l = new ArrayList<FullInfoMesh>();
        l.add(m);
        return l;
    }

    public EdgeContraction(FullInfoMesh mesh) {
        this(mesh, false);
    }

    public EdgeContraction(FullInfoMesh mesh, boolean edgeLengthOnly) {
        this(EdgeContraction.makeList(mesh), edgeLengthOnly);
    }

    public EdgeContraction(ArrayList<FullInfoMesh> meshes, boolean edgeLengthOnly) {
        this.LENGTH_ONLY = edgeLengthOnly;
        this.queue = new TreeSet<CEdge>(new EdgeComparator());
        this.mesh = meshes;
        int meshIdx = 0;
        for (FullInfoMesh fim : this.mesh) {
            for (FullInfoMesh.Edge e : fim.edges.keySet()) {
                CEdge ce = new CEdge(e, meshIdx);
                this.edgeCosts.put(ce, Float.valueOf(this.computeCost(ce)));
                this.queue.add(ce);
            }
            ++meshIdx;
        }
    }

    public ArrayList<FullInfoMesh> getMeshes() {
        return this.mesh;
    }

    protected float computeCost(CEdge ce) {
        float l = this.getLength(ce);
        if (this.LENGTH_ONLY) {
            return l;
        }
        FullInfoMesh fim = this.mesh.get(ce.meshIdx);
        FullInfoMesh.Edge e = ce.edge;
        HashSet<Integer> triangles = new HashSet<Integer>();
        triangles.addAll(fim.getVertex((int)e.p1).triangles);
        triangles.addAll(fim.getVertex((int)e.p2).triangles);
        for (int i : e.triangles) {
            triangles.remove(i);
        }
        float angle = 0.0f;
        Vector3f oldN = new Vector3f();
        Vector3f newN = new Vector3f();
        Point3f midp = this.getMidpoint(ce);
        Iterator iterator = triangles.iterator();
        while (iterator.hasNext()) {
            int fIdx = (Integer)iterator.next();
            int f1 = fim.faces.get(fIdx * 3);
            int f2 = fim.faces.get(fIdx * 3 + 1);
            int f3 = fim.faces.get(fIdx * 3 + 2);
            FullInfoMesh.Vertex v1 = fim.getVertex(f1);
            FullInfoMesh.Vertex v2 = fim.getVertex(f2);
            FullInfoMesh.Vertex v3 = fim.getVertex(f3);
            this.getNormal(v1, v2, v3, oldN);
            if (f1 == e.p1 || f1 == e.p2) {
                this.getNormal(midp, v2, v3, newN);
            } else if (f2 == e.p1 || f2 == e.p2) {
                this.getNormal(v1, midp, v3, newN);
            } else if (f3 == e.p1 || f3 == e.p2) {
                this.getNormal(v1, v2, midp, newN);
            }
            oldN.normalize();
            newN.normalize();
            float dAngle = oldN.angle(newN);
            if (Float.isNaN(dAngle)) continue;
            angle += oldN.angle(newN);
        }
        return l * angle;
    }

    private final boolean shouldFuse(CEdge ce) {
        FullInfoMesh fim = this.mesh.get(ce.meshIdx);
        FullInfoMesh.Edge e = ce.edge;
        HashSet<FullInfoMesh.Vertex> neighborVertices = new HashSet<FullInfoMesh.Vertex>();
        int n1 = fim.getVertex((int)e.p1).edges.size() + 1;
        if (n1 < 5) {
            return false;
        }
        for (FullInfoMesh.Edge e1 : fim.getVertex((int)e.p1).edges) {
            neighborVertices.add(fim.getVertex(e1.p1));
            neighborVertices.add(fim.getVertex(e1.p2));
        }
        int n2 = fim.getVertex((int)e.p2).edges.size() + 1;
        if (n2 < 5) {
            return false;
        }
        for (FullInfoMesh.Edge e2 : fim.getVertex((int)e.p2).edges) {
            neighborVertices.add(fim.getVertex(e2.p1));
            neighborVertices.add(fim.getVertex(e2.p2));
        }
        return neighborVertices.size() == n1 + n2 - 4;
    }

    private final void fuse(CEdge ce) {
        if (!this.shouldFuse(ce)) {
            return;
        }
        FullInfoMesh fim = this.mesh.get(ce.meshIdx);
        FullInfoMesh.Edge e = ce.edge;
        for (FullInfoMesh.Edge ed : fim.getVertex((int)e.p1).edges) {
            this.queue.remove(new CEdge(ed, ce.meshIdx));
        }
        for (FullInfoMesh.Edge ed : fim.getVertex((int)e.p2).edges) {
            this.queue.remove(new CEdge(ed, ce.meshIdx));
        }
        Point3f midp = this.getMidpoint(ce);
        int mIdx = fim.contractEdge(e, midp);
        HashSet<FullInfoMesh.Edge> newEdges = fim.getVertex((int)mIdx).edges;
        for (FullInfoMesh.Edge edge : newEdges) {
            CEdge cEdge = new CEdge(edge, ce.meshIdx);
            this.edgeCosts.put(cEdge, Float.valueOf(this.computeCost(cEdge)));
            this.queue.add(cEdge);
        }
        ArrayList<Integer> neighbors = new ArrayList<Integer>();
        for (FullInfoMesh.Edge edge : newEdges) {
            if (edge.p1 != mIdx) {
                neighbors.add(edge.p1);
            }
            if (edge.p2 == mIdx) continue;
            neighbors.add(edge.p2);
        }
        HashSet<FullInfoMesh.Edge> hashSet = new HashSet<FullInfoMesh.Edge>();
        Iterator iterator = neighbors.iterator();
        while (iterator.hasNext()) {
            int n = (Integer)iterator.next();
            hashSet.addAll(fim.getVertex((int)n).edges);
        }
        hashSet.removeAll(newEdges);
        for (FullInfoMesh.Edge ed : hashSet) {
            this.queue.remove(new CEdge(ed, ce.meshIdx));
        }
        for (FullInfoMesh.Edge edge : hashSet) {
            CEdge cEdge = new CEdge(edge, ce.meshIdx);
            this.edgeCosts.put(cEdge, Float.valueOf(this.computeCost(cEdge)));
            this.queue.add(cEdge);
        }
    }

    void getNormal(Point3f p1, Point3f p2, Point3f p3, Vector3f ret) {
        this.v1.sub((Tuple3f)p2, (Tuple3f)p1);
        this.v2.sub((Tuple3f)p3, (Tuple3f)p1);
        ret.cross(this.v1, this.v2);
    }

    void getMidpoint(CEdge e, Point3f ret) {
        FullInfoMesh.Vertex p1 = this.mesh.get(e.meshIdx).getVertex(e.edge.p1);
        FullInfoMesh.Vertex p2 = this.mesh.get(e.meshIdx).getVertex(e.edge.p2);
        ret.add((Tuple3f)p1, (Tuple3f)p2);
        ret.scale(0.5f);
    }

    Point3f getMidpoint(CEdge e) {
        Point3f ret = new Point3f();
        this.getMidpoint(e, ret);
        return ret;
    }

    float getLength(CEdge e) {
        return this.mesh.get(e.meshIdx).getVertex(e.edge.p1).distance(this.mesh.get(e.meshIdx).getVertex(e.edge.p2));
    }

    private final class EdgeComparator
    implements Comparator<CEdge> {
        private final Point3f mp1 = new Point3f();
        private final Point3f mp2 = new Point3f();

        private EdgeComparator() {
        }

        @Override
        public int compare(CEdge e1, CEdge e2) {
            float l2;
            if (e1.equals(e2)) {
                return 0;
            }
            float l1 = ((Float)EdgeContraction.this.edgeCosts.get(e1)).floatValue();
            if (l1 < (l2 = ((Float)EdgeContraction.this.edgeCosts.get(e2)).floatValue())) {
                return -1;
            }
            if (l2 < l1) {
                return 1;
            }
            if (e1.meshIdx < e2.meshIdx) {
                return -1;
            }
            if (e1.meshIdx > e2.meshIdx) {
                return 1;
            }
            EdgeContraction.this.getMidpoint(e1, this.mp1);
            EdgeContraction.this.getMidpoint(e2, this.mp2);
            if (this.mp1.z < this.mp2.z) {
                return -1;
            }
            if (this.mp1.z > this.mp2.z) {
                return 1;
            }
            if (this.mp1.y < this.mp2.y) {
                return -1;
            }
            if (this.mp1.y > this.mp2.y) {
                return 1;
            }
            if (this.mp1.x < this.mp2.x) {
                return -1;
            }
            if (this.mp1.x > this.mp2.x) {
                return 1;
            }
            return 0;
        }
    }

    private final class CEdge {
        final FullInfoMesh.Edge edge;
        final int meshIdx;

        CEdge(FullInfoMesh.Edge edge, int mIdx) {
            this.edge = edge;
            this.meshIdx = mIdx;
        }

        public boolean equals(Object o) {
            CEdge e = (CEdge)o;
            return this.meshIdx == e.meshIdx && this.edge.equals(e.edge);
        }

        public int hashCode() {
            long bits = 1L;
            bits = 31L * bits + (long)this.edge.p1;
            bits = 31L * bits + (long)this.edge.p2;
            bits = 31L * bits + (long)this.meshIdx;
            return (int)(bits ^ bits >> 32);
        }
    }
}

